/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "style.h" 
#include "iring.h"
#include "vars.h"

extern int verbose;
extern int prlevel ;
extern int numvars; /* number of vars in current ring */
long tullexp[NVARS] ;
int deg ;
extern int binom();

i_tull(numvars, d)
int numvars, d ;
{
	int i ;
	
	for (i=0; i<numvars; i++)
		tullexp[i] = 0 ;
	deg = d ;
}

void
tull(head, plus)
arrow head;
int plus;
{
	int i, j, d, e, n, n2, c1, c2, s;
	int *a;
  
	d = head->umh.mpred;
	n = head->umh.mn;
	n2 = head->umh.mpren;
	a = head->umh.mloc->umn.mexp;
	for ( i=0; i<n; ++i)
		d += a[i];
	if (d > deg) return;
	/* d == degree of new monomial */
	e = deg - d;
	c1 = binom(numvars-1+e, e);
	c2 = (e == 0 ? 0 : binom(numvars-1+e, e-1));
	s = (plus ? -1 : 1); /* yeah, that's right, buster */
	for (i=0, j=0; i<n2; ++i, ++j)
		tullexp[j] += s * (c1*head->umh.mstack[i].mpre + c2);
	for (i=0; i<n; ++i, ++j)
		tullexp[j] += s * (c1*a[i] + c2);
}

boolean
hulb(M, d)
     gmatrix M ;
     int d ;
{
    /* returns TRUE if user doesn't interrupt */
    arrow head ;
    arrow monhilb() ;

    i_tull(numvars, d) ;
    if ((head = monhilb(M, 1, tull)) == NULL)
        return(FALSE) ;
    monrefund(head) ;
    return(TRUE) ;
}
/*
boolean
hulb(M, d)
gmatrix M ;
int d ;
{
	
    expterm nexp ;
    poly f ;
    arrow head ;
    modgen mg ;
	
	i_tull(numvars, d) ;
	head = monnewhead(numvars) ;
	stdFirst(M, &mg, USESTD) ;
	while ((f=stdNext(&mg)) ISNT NULL) {
	    if (have_intr()) {
			monrefund(head) ;
			print("\n") ;
			return(FALSE) ;
	    }
	    sToExp(INITIAL(f), nexp) ;
	    monadjoin(head, nexp, tull) ;
	}
	monrefund(head) ;
    return(TRUE) ;
}
*/
hulb_cmd(argc, argv)
int argc ;
char *argv[] ;
{
    gmatrix M ;
	int i, d;

    if (argc ISNT 3) {
		print("hulb <standard basis> <deg>\n") ;
		return ;
    }
    GET_MOD(M, 1) ;
    d = getInt(argv[2]) ;
    stdWarning(M) ;
	hulb(M, d) ;
	for (i=0; i<numvars; i++) 
		print("%ld ", tullexp[i]) ;
	print("\n") ;
}

/*
int calledyet ;

i_hull()
{
	calledyet = 0 ;
}

int *
hull_question(tullexp)
int *tullexp ;
{
	int i ;
	int *p ;
	int argc ;
	char **argv ;
	
	if (calledyet IS 0) {
		calledyet = 1 ;
	} else {
		for (i=0; i<numvars; i++)
			print("%d ", tullexp[i]) ;
		print("\n") ;
	}
	
	prinput("weight function") ;
	get_line(&argc, &argv) ;
	if (argc IS 0) return(NULL) ;
	p = (int *) gimmy(argc*sizeof(int)) ;
	for (i=0; i<argc; i++)
		p[i] = getInt(argv[i]) ;
	return(p) ;
}
*/

prWt(exp)
long *exp ;
{
	int i ;
	
	print("[") ;
	for (i=0; i<numvars-1; i++)
		print("%ld ", exp[i]) ;
	print("%ld]\n", exp[numvars-1]) ;
}

variable *
mkWeightRing(name)
char *name ;
{
	dlist nv, wtfcns ;
	ring R ;
	variable *p ;
	ring rgCreate() ;
	
	dl_init(&nv) ;
	dl_insert(&nv, RWTFCN) ;
	dl_insert(&nv, numvars) ;
	
	dl_init(&wtfcns) ;
	dl_new(&wtfcns, numvars) ;
	
	R = rgCreate(charac, varnames, &rgDegs, &nv, &wtfcns) ;
	p = make_var(name, MAINVAR, VRING, NULL) ;
	if (p IS NULL) return(NULL);
	set_value(p, R) ;
	return(p) ;
}

extern int h_count;

hull(rgname, idname, d, fil)
char *rgname, *idname ;
int d ;
FILE *fil ;
{
    variable *cRing, *R, *vI, *sI ;
    long *wt ;
    int nstdbases ;
    gmatrix f ;  /* ring map */
    gmatrix IR, J, Ideal ;
    gmatrix imap() ;
    gmatrix mat_apply() ;
    variable *std() ;
    long *hull_question() ;

    if (i_hull(numvars, fil) IS 0) return ;
    nstdbases = 0 ;
    cRing = current_ring ;	/* assert: this should be ring of idname */
    R = mkWeightRing("xxxr") ;
    while ((wt = hull_question(tullexp)) ISNT NULL) {
	if (verbose > 0) {
	    print("\n%d\nweights: ", ++h_count) ;
	    prWt(wt) ;
	} else 
	  prlevel++ ;

	cRing = vget_ring(rgname) ;
	R = find_var("xxxr") ;
	vrg_install(R) ;
	Ideal = VAR_MODULE(find_var(idname)) ;
	
	(*blocks)->degs = wt ;/* change weight function of R, in first block */
	f = imap(cRing, R, TRUE) ;	
	IR = mat_apply(f, cRing, R, Ideal) ;
	vI = make_var("xxx", MAINVAR, VMODULE, R) ;
	set_value(vI, IR) ;
	
	sI = std("xxxs", vI) ;
	/* calc(sI, TRUE) ; HACK do std basis thru all degrees */
	calc(sI, FALSE, d) ; /* do std basis thru degree d */
	
	J = VAR_MODULE(sI->b_alias) ;/* b_alias points to std basis variable */
	hulb(J, d) ;
	nstdbases++ ;
	if (verbose > 0) {
	    print("point: ") ;
	    prWt(tullexp) ;
	} else
	  prlevel-- ;
	rem_var(vI) ; rem_var(sI) ; mod_kill(f) ;
	garb_collect() ;	/* pray that user hasn't removed idname, 
				   rgname, or "xxxr" */
    }
    R = find_var("xxxr") ;
    rem_var(R) ;
    cRing = find_var(rgname) ;
    vrg_install(cRing) ;
    print("\n%d standard bases computed\n", nstdbases) ;
}
		
		
		
hull_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	int d ;
	FILE *fil, *topen() ;
	variable *p ; ;
	
	if ((argc < 3) OR (argc > 4)) {
		print("hull <ideal> <degree> [file]\n") ;
		return ;
	}
	GET_VMOD(p, 1) ;
	d = getInt(argv[2]) ;
	if (argc IS 3)
		fil = stdout ;
	else
		fil = topen(argv[3], "w") ;
	hull(current_ring->name, p->name, d, fil) ;
	if (fil ISNT stdout) fclose(fil) ;
}
