/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "hull.h"

matrix *
rand_points(rows, cols, lim)
int rows, cols, lim;
/* return a list of random points */
/* each row is a point with coords in range -lim..lim-1 */
{
	matrix *p;
	int i, j;
	long x, sum;
	
	p = new_matrix(rows, cols);
	for (i=0; i<rows; ++i) {
		sum = 0;
		for (j=0; j<cols-1; ++j) {
			x = (rand() % (2 * lim)) - lim;
			sum += x;
			p->v[i]->v[j] = x;
		}
		p->v[i]->v[cols-1] = - sum;
	}
	return p;
}

matrix *
input_points()
/* return a list of points */
/* read points from file rows, cols, coords */
{
	int rows, cols;
	matrix *p;
	int i, j;
	long x;
	char name[20];
	FILE *fp, *topen();
	
	printf("enter input file name : \n");
	gets(name);
	fp = topen(name, "r");
/*	fp = fopen("points", "r"); */
	ERROR_IF(fp == NULL, "input_points");
	fscanf(fp, "%d%d", &rows, &cols);
	p = new_matrix(rows, cols);
	for (i=0; i<rows; ++i) {
		for (j=0; j<cols; ++j) {
			fscanf(fp, "%ld", &x);
			p->v[i]->v[j] = x;
		}
	}
	return p;
}

vector *
extreme_pt(p, w)
matrix *p;
vector *w;
/* return point having minimum dot product with w */
{
	int i, best, rows;
	long min, new;
	
	rows = p->rows;
	best = 0;
	min = dot_prod(p->v[0], w);
	for (i=1; i<rows; ++i) {
		new = dot_prod(p->v[i], w);
		if (min > new) {
			min = new;
			best = i;
		}
	}
	return copy_vector(p->v[best]);
}


