/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "hull.h"

matrix *
simplex(p)
matrix *p;
{
	int n, dim, coord;
	vector *v, *w, *x, *newpt, *first;
	matrix *verts, *span, *perp, *both;
	long val;
	
	n = p->cols;
	verts = new_matrix(0,n);
	span = new_matrix(0,n);
	perp = new_matrix(0,n);
	both = new_matrix(0,n);	
	
	ERROR_IF(n != 4, "simplex");
	v = new_vector(n);
	basis_vector(v,0);
	w = copy_vector(v);
	
	newpt = extreme_pt(p,w);
	first = newpt;
	verts = adjoin_row(verts, newpt);
	val = dot_prod(w, newpt);
	neg_vector(w);
	newpt = extreme_pt(p,w);
	if (dot_prod(w, newpt) == -val) { 
		adjoin_row(perp, w);
		adjoin_row(both, w);
	}
	else {
		x = add_vectors(1L,newpt,-1L,first);
		verts = adjoin_row(verts, newpt);
		span = adjoin_row(span,x);
		both = adjoin_row(both,x);
		free_vector(x);
	}
	free_vector(w);
	coord = 0;	
	for (dim=1; dim<n; ++dim) {
		basis_vector(v, coord);
		w = normal_vector(both, v);
		while (ziptest_vector(w) == 0) {
			free_vector(w);
			++coord;
			basis_vector(v, coord);
			w = normal_vector(both, v);
		}
		newpt = extreme_pt(p,w);
		val = dot_prod(w, first);
		if (dot_prod(w, newpt) == val) { 
			neg_vector(w);
			newpt = extreme_pt(p,w);
			if (dot_prod(w, newpt) == -val) {
				perp = adjoin_row(perp, w);
				both = adjoin_row(both, w);
			}
			else {
				x = add_vectors(1L,newpt,-1L,first);
				verts = adjoin_row(verts, newpt);
				span = adjoin_row(span,x);
				both = adjoin_row(both,x);
				free_vector(x);
			}
		}
		else {
			x = add_vectors(1L,newpt,-1L,first);
			verts = adjoin_row(verts, newpt);
			span = adjoin_row(span,x);
			both = adjoin_row(both,x);
			free_vector(x);
		}
		free_vector(w);
	}
	return verts;
}
