#include "config.h"
extern int PageSize;
#define UndoLinkFlag 1
#define UndoEqualFlag 2
#define UndoSetFlag 3
#define UndoLastFlag 4
#define UndoChangeFlag 5
#define UndoSeekFlag 6
#define UndoJoinFlag 7
#define UndoChangesFlag 8

#ifdef Vsystem
#define HAVE_PAGE_ALLOC
#define UNDO_CHUNK_SIZE PageSize
#else
#define UNDO_CHUNK_SIZE 1024
#endif

#ifndef HAVE_PAGE_ALLOC
extern char *UndoBuffer;
#endif

#ifdef CPLUS
#ifndef GVARS_H
class CVariable;
#endif
#endif

typedef union _Undo_ UndoCommand;

struct UndoEqual {
    short kind;		/* UndoEqualFlag */
#ifdef CPLUS
    CVariable *var;
#else
    union _Var *var;
#endif
};

struct UndoLink {
    short kind;		/* UndoLinkFlag */
    UndoCommand *prev;
#ifndef HAVE_PAGE_ALLOC
    char *buffer;
#endif
};

struct UndoSet {
    short kind;		/* UndoSetFlag or UndoLastFlag */
#ifdef CPLUS
    CVariable *var;
#else
    union _Var *var;
#if 0 /*def LittleEndian*/
    short misc, flags;
#else /*BigEndian */
    short flags, misc;
#endif
#endif
};

struct UndoChange {
    short kind;		/* UndoChange */
    void *ptr;
    void *old;
};

struct UndoChanges {
    short kind;		/* UndoChanges */
    void *ptr;
    int length;
    /* saved data follows */
};

struct UndoSeek {
    short kind; 	/* UndoSeekFlag */
    struct GenFile *file;
    HandlerDesc *savedHandlerAtLastSeek;
    void *savedIndex;
};

struct UndoJoin {
    short kind; 	/* UndoJoin */
    void *ptr1, *ptr2;
};

union _Undo_ {
    short kind;
    struct UndoLink link;
    struct UndoEqual equal;
    struct UndoSet set;
    struct UndoChange change;
    struct UndoChanges changes;
    struct UndoSeek seek;
    struct UndoJoin join;
};

#if 0
#define PerProcess (struct PerProcessArea*)\
  ({ int tmp; asm("movl sp," tmp); tmp & PageMask);
#endif

EXTERN UndoCommand *GetUndoCommand(int size);
EXTERN void SaveUndoChanges(void *, int);
EXTERN void ClearUndoCommands(void);
