/* Copyright Per Bothner 1987. Read the file Q-INFO */
#ifndef MACHINES_H
#define MACHINES_H

/* the default register names are listed first, then aliases */
struct RegNameEntry
  { int regNo; char *regName;};

typedef int RegSet; /* a mask of registers */
#define RegAsSet(reg) (1 << (reg))
#define RegInSet(reg, reg_set) (RegAsSet(reg) & (reg_set))
#define RegRangeAsSet(lo, hi) (((-1) << (lo)) ^ ((-2) << (hi)))

struct MachineDesc
  {
    char machineType; /* 'm'==m68k; 'v'==vax */
    int (*putEffectiveAddress)();
    int (*procReturn)();
    short stPtrReg;
    short frPtrReg;
    int (*addConstant)();
    struct DataToken *(*indexToken)();
    struct RegNameEntry *regNames; /* map register numbers to names */
    short argReg;
    short ctxReg;
    RegSet indexRegs; /* indexable registers */
    RegSet workRegs; /* available as working registers; not PC, SP, FP */
    short auxReg;
  };

extern struct MachineDesc M68kDesc[1], VaxDesc[1];

#define ThisMachineType 'M'
#define ThisMachineDesc M68kDesc

#define CRegName(regNo, cf) ((cf)->machineDesc->regNames[regNo].regName)
#endif MACHINES_H
