/* Copyright Per Bothner 1987. Read the file Q-INFO */
#ifndef Include_DEBUG
#define Include_DEBUG
#include <stdio.h>
#include <stdarg.h>
extern long flags;
#define Debug flags
#define DebugRefs 1
#define DebugCompiled 2	/* print out the parsed expression before evaluation */
#define DebugNoFree 4
#define DebugFlatVars 8
#define DebugAbort 16	/* call abort if error is called */

#define LogExprIndex 0
#define LogCodeIndex 1
#define LogCodeGenIndex 2
#define LogRefCountIndex 3
#define LogVerboseIndex 4
#ifndef MULTI_PROCESS
extern short LogFlags[5];
#else
#define LogFlags (PerProcess->logFlags)
#endif
#define LogExpr LogFlags[LogExprIndex]
#define LogCode LogFlags[LogCodeIndex]
#define LogCodeGen LogFlags[LogCodeGenIndex]
#define LogRefCount LogFlags[LogRefCountIndex]
#define LogVerbose LogFlags[LogVerboseIndex]

#define NewHandler (LogVerbose & 2)

/*extern struct FormattedFile *LogFile;*/
extern FILE *LogFile;

/* Error messages */
#define ParseTimeErr 'p'
#define TraverseTimeErr 'o'
#define CompileTimeErr 'c'
#define RunTimeErr 'r'

/* Error levels */
#define InfMessage 0	/* information message */
#define NteMessage 1	/* note */
#define WrnMessage 2	/* wraning message */
#define ErrMessage 3	/* error message - cannot run */
#define FtlMessage 4	/* fatal error */

struct Location;
extern void RunError(int code, const char *format, ...);
struct Location;
extern void ErrorPrint(char when, int level, struct Location *sourcePos,
		  FILE *file, char *message, va_list argList);
extern int CheckErrorLevel(char *message);
#endif /*!Include_DEBUG*/
