/*	Copyright (C) 1992 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */



#include "bitset.h"

int
ut_bitset_equal (size, a, b)
     int size;
     ut_Bitset a;
     ut_Bitset b;
{
  int x;
  UT_subset s = b[0];
  b[0] = ~a[0];

  for (x = ut_bitset_numb_subsets(size) - 1; a[x] == b[x]; --x)
    ;

  b[0] = s;
  return !x && s == a[0];
}

int ut_bitset_is_subset (size, a, b)
     int size;
     ut_Bitset a;
     ut_Bitset b;
{
  int x = ut_bitset_numb_subsets(size) - 1;
  while (x-- && (a[x] & b[x]) == a[x]);
  return x == -1;
}

int
ut_bitset_empty (size, set)
     int size;
     ut_Bitset set;
{
  int x;
  UT_subset s = set[0];
  set[0] = 1;
  for (x = ut_bitset_numb_subsets(size) - 1; !set[x]; --x)
    ;
  set[0] = s;
  return !s;
}

void
ut_bitset_null (size, b)
     int size;
     ut_Bitset b;
{
  bzero (b, ut_sizeof_bitset(size));
}

void
ut_bitset_universe (size, b)
     int size;
     ut_Bitset b;
{
  int x = ut_bitset_numb_subsets (size);
  while (x--)
    *b++ = ~(UT_subset)0;
}

void
ut_bitset_complement (size, b)
     int size;
     ut_Bitset b;
{
  int x = ut_bitset_numb_subsets (size);
  while (x--)
    {
      *b = ~*b;
      ++b;
    }
}

#define COMBINER(OP,NAME)					\
void NAME (size, a, b)						\
     int size;							\
     ut_Bitset a;						\
     ut_Bitset b;						\
{								\
  int x;							\
  for (x = ut_bitset_numb_subsets(size); x >=0; --x)		\
    a[x] OP b[x];						\
}

COMBINER(=, ut_bitset_assign)
COMBINER(|=, ut_bitset_union)
COMBINER(&=, ut_bitset_intersection)
COMBINER(&=  ~, ut_bitset_difference)
COMBINER(= ~a[x] &, ut_bitset_revdifference)
COMBINER(^=, ut_bitset_xor)

unsigned long
ut_bitset_hash (size, b)
     int size;
     ut_Bitset b;
{
  int x;
  unsigned long hash = (unsigned long)ut_bitset_hash;

  for (x = ut_bitset_numb_subsets(size) - 1; x >= 0; --x)
    hash ^= ut_bitset_subset_val(b, x);

  return hash;
}


UT_subset ut_subset_singletons [UT_subset_bits] = 
{
  0x1,
  0x2,
  0x4,
  0x8,
  0x10,
  0x20,
  0x40,
  0x80,
  0x100,
  0x200,
  0x400,
  0x800,
  0x1000,
  0x2000,
  0x4000,
  0x8000,
  0x10000,
  0x20000,
  0x40000,
  0x80000,
  0x100000,
  0x200000,
  0x400000,
  0x800000,
  0x1000000,
  0x2000000,
  0x4000000,
  0x8000000,
  0x10000000,
  0x20000000,
  0x40000000,
  0x80000000
};
