(define (update new-passkey passkey-checker)
  (letrec ((updated-checker
            (lambda (passkey)
              (if (= passkey new-passkey) #t (passkey-checker passkey)))))
    updated-checker))

(define (no-keys n) #f)

(define (make-checker passkeys)
  (if (null? passkeys)
      no-keys
      (update (car passkeys) (make-checker (cdr passkeys)))))

(define 12-0-18 (make-checker (list 12 0 18)))
(define 2-4-6 (update 2 (update 4 (update 6 no-keys))))

(2-4-6 2)

(2-4-6 1)
