;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                      ;
; COMMANDS that can be invoked in the SUB-EVAL loop.          ;
;                                                                      ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(define (menu)
"
   Sub-Eval commands: enter (without parens or quotes)
   at the `SUB-EVAL==>' prompt and execute with C-x C-e.
   (See file Guide.doc for further help.)

exit-sm | quit-sm            Exit the SUB-EVAL loop safely
help-sm                      Show this help menu
load-sm-file                 prompts for file of expressions to SUB-EVAL
import-code                  prompts for file of Scheme definitions to
                                install as SUB-EVAL system-constants
show-global-bindings         Display global bindings
verbose                      Show all steps
concise                      Show `interesting' steps (the default)
verbtog                      Toggle Verbose/Concise mode
rule-names-on                Show name of rule applied
rule-names-off
reinit-globals               Reinitializes environments and counters
")

(define (interface-command? exp)
  (memq exp inter-face-command-list))

(define inter-face-command-list
        '(exit-sm quit-sm
          help-sm
          load-sm-file load-sm
          import-code
          show-global-bindings
          verbose concise verbtog
          rule-names-on rules-names-off
          reinit-globals))

(define (driver-loop)
  (call/cc (lambda (return-to-scheme)
             (driver return-to-scheme))))

(define (driver return-to-scheme)
  (newline)
  (display "SUB-EVAL==> ")
  (newline)
  (let ((exp (read)))
    (top-level-eval exp return-to-scheme)
    (driver return-to-scheme)))

(define (top-level-eval exp return-to-scheme)
  (cond
   ((equal? exp '(driver-loop))
    (newline)
    (display "Already within driver-loop. C-c C-c to exit")
    (newline))
   ((interface-command? exp)
    (dispatch-interface-command exp return-to-scheme))
   (else
    (set! display-variable #t)
    (set! line-count 0)
    (set! line-of-first-step line-count)    ;;;REVISED
    (set! record-of-steps ())
    (let ((exp1 (top-level-desugar exp)))
      (if (define? exp1)
          (let* ((def-variable (cadr exp1))
                 (def-exp (garbage-collect (caddr exp1)))
                 (def-value (eval-loop def-exp)))
            (do-bindings def-variable def-value)
            (display-reductions def-value)
            (define-output def-variable))
          (let ((exp2 (garbage-collect exp1)))
            (display-reductions exp2)
            (let ((final-val (eval-loop exp2)))
              (if (zero? line-count) (display-reductions final-val 'force-display))
              (display-reductions final-val))))))))

(define (dispatch-interface-command exp return-to-scheme)
  (case exp
    ((exit-sm quit-sm) (return-to-scheme "Exiting SUB-EVAL"))
    ((help-sm) (newline) (display (menu)) undefined-value)
    ((load-sm-file load-sm) (load-sm-file) undefined-value)
    ((import-code) (import-code) undefined-value)
    ((show-global-bindings) (pp the-global-environment) undefined-value)
    ((verbose) (verbose-on) undefined-value)
    ((concise) (verbose-off) undefined-value)
    ((verbtog) (verbtog) undefined-value)
    ((rule-names-on) (rule-names-on) undefined-value)
    ((rule-names-off) (rule-names-off) undefined-value)
    ((reinit-globals) (initialize-system-globals) undefined-value)))

(define (import-code)
  (newline)
  (display "Enter filename within double quotes: ")
  (install-system-defs (read)))

(define (load-sm-file)
  (newline)
  (display "Enter filename within double quotes: ")
  (load-user-sm-file (read)))

(define (verbtog)                         ;REVISE end proc name with !
  (if verbose
      (verbose-off)
      (verbose-on)))

(define (verbose-on)                         ;REVISE end proc name with !
  (newline)
  (display "Setting to Verbose mode")
  (newline)
  (set! verbose #t))

(define (verbose-off)                         ;REVISE end proc name with !
  (newline)
  (display "Setting to Concise mode")
  (newline)
  (set! verbose #f))


                           ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                           ;;;                        ;;;
                           ;;;     TRACING RULES      ;;;
                           ;;; (As yet unimplemented) ;;;
                           ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; GLOBAL FLAGS FOR RULES:
;(define trace-beta-redex #f)
;(define trace-let-gc #f)
;(define trace-letrec-gc #f)
;(define trace-let-apply #f)
;(define trace-letrec-apply #f)
;(define trace-if #f)
;(define trace-cond #f)
;(define trace-or #f)
;(define trace-and #f)
;(define trace-scheme-eval #f)

(define (rule-names-on)
  (newline)
  (display "Recording rule-names")
  (newline)
  (set! show-rule-names #t))

(define (rule-names-off)
  (newline)
  (display "Rule-names will not be recorded")
  (newline)
  (set! show-rule-names #f))

