/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  vector.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




//------------------------------------------------------------------------------
//  vectors
//------------------------------------------------------------------------------

#ifndef VECTOR_REPH
#define VECTOR_REPH

#include <LEDA/basic.h>


class vector
{
  friend class matrix;

  double* v;
  int d;

  void check_dimensions(const vector&) const;
 
public:

  vector(int=0); 
  vector(double, double);
  vector(double, double, double);
  vector(const vector&);
 ~vector() { if (v) delete v; }
 

  double length() const;
  
  int    dim()    const { return d; }
  vector norm()   const { return *this/length(); }
  
  double angle(const vector&) const; 
  
  vector& operator=(const vector&);
  
  double& operator[](int);
  
  double  operator[](int) const;
  
  vector  operator+(const vector&) const;
  vector  operator-(const vector&) const;
  vector  operator*(double)        const;
  vector  operator/(double)        const;
  double  operator*(const vector&) const;
  
  int     operator==(const vector&) const;
  int     operator!=(const vector& w)  const { return !(*this == w); }
  
  /*
  friend vector operator*(double f, const vector& v);
  friend vector operator/(const vector& v, double f);
  */
  
  
  friend ostream& operator<<(ostream& o, const vector& v);
  friend istream& operator>>(istream& i, vector& v);
  
  friend void Print(const vector& v, ostream& out=cout) { out << v; } 
  friend void Read(vector& v, istream& in=cin)  { in >> v; }
  
  friend void   Init(vector& x)          { x = vector(0); }
  friend void   Clear(vector& x)         { delete (vector*)&x; }
  friend GenPtr Copy(vector& x)          { return new vector(x); }
  friend GenPtr Convert(vector& x)       { return &x; }
  friend vector& Access(const vector&, GenPtr p) { return *(vector*)p; }
  friend int compare(const vector&, const vector&) { return 0; }
  
  LEDA_MEMORY(vector)

};


//------------------------------------------------------------------------------
// VECTOR(cmp): vector with user defined linear order cmp
//------------------------------------------------------------------------------

#define VECTOR(cmp) name2(vector_,cmp)

#define VECTORdeclare(cmp)\
struct VECTOR(cmp) : public vector \
{  VECTOR(cmp)(double r)       :vector(r) {}\
   VECTOR(cmp)(vector  r )     :vector(r) {}\
   VECTOR(cmp)(const VECTOR(cmp)& r) :vector(r) {}\
   VECTOR(cmp)() {}\
 ~ VECTOR(cmp)() {}\
};\
\
int compare(const VECTOR(cmp)& x, const VECTOR(cmp)& y) { return cmp(x,y); }

#endif
