.TH "MARCHING CUBES" 1 "1 December 1990" "LBL"
.PD 1.4
.SH NAME
.B march
-tessellate a dense array of data.
.SH SYNOPSIS
.B march
[-n][-a][-s NN][-t NN] < 3d_data.hips > polygon_file
.SH DESCRIPTION
.I march
March is a routine designed to tessellate a dense array of data
(in HIPS format) using an implementation of the Marching Cubes
algorithm described by Lorensen and Cline in the Siggraph '87 proceedings.
The routine will take the array of data as input and tessellate it at
a given surface value, and create a file of vertices, normals, and edges.

.SH OPTIONS
.na
.nf
   -n           create vertex normals (default = OFF)
   -a           ascii file output (default = OFF)
   -s NN        surface threshold value (default = 50)
   -t NN        transparency (range = 0 to 10, 10 = off, default = 10)

.SH "SEE ALSO"
.BR scry (1)

Lorensen, William E. and Cline, Harvey E.  Marching Cubes: A High
Resolution 3D Surface Construction Algorithm
.I SIGGRAPH '87 Conference Proceedings 21,
4 (July 1987), 163-169.

.SH AUTHORS
Max Rible, LBL         original Marching Cubes routine
.br
Brian Tierney, LBL     HIPS front end, plus a few bug fixes
.SH BUGS
Report to Brian Tierney.      email: bltierney@lbl.gov

