/*
 * Module	:	xsin Date	:	8807.14 Author	:	J.
 * Neisen -- Minnesota Supercomputer Center Purpose	:	X11 color
 * table editor. Uses all sorts of widgets for nice things.
 * 
 * $Log:	main.c,v $ Revision 1.2  88/08/20  12:35:50  joel Made it posiible
 * to run on a B/W server
 * 
 * Revision 1.1  88/08/17  13:22:49  joel Initial revision
 * 
 * 
 */

#include	<stdio.h>
#include	<X11/Intrinsic.h>
#include	<X11/VPaned.h>
#include	<X11/Box.h>
#include	<X11/Text.h>
#include	<X11/AsciiText.h>
#include	<Xw/Xw.h>
#include	<Xw/PButton.h>
#include	<Xw/Toggle.h>

#include	"cmap.h"

int	has_color;		/*  boolean - are we dreaming in color?  */

int     count[NBOX] = { 2, 2, 2, 2 };
enum colorscheme colorscheme = RGB;
int	spline = 0;
struct cval cval[NBOX][MAXVALS];

int	boxwidth = WIDTH;
int	boxheight = HEIGHT;

int	pixar	= 0;

GC	gc_w1[2], gc_w2[2];
Display	*display;
Visual	*visual = NULL;
Colormap color_map;
XColor	lut[256];
XColor	save[4] = {
    {0, 0xffff, 0xffff, 0xffff, DoRed | DoGreen | DoBlue},
    {1, 0,	0,	0,	DoRed | DoGreen | DoBlue},
    {2, 0xffff, 0xffff, 0xffff, DoRed | DoGreen | DoBlue},
    {3, 0,	0,	0,	DoRed | DoGreen | DoBlue},
};



main (argc, argv)
    int		argc;
    char	**argv;
{
    Widget	toplevel, outer;
    Arg		arg[10];
    int		nc;
    int		maincolor = 0;
    Screen	*screen;
    int		i;

    toplevel = XtInitialize (NULL, "CMap", NULL, 0, &argc, argv);
    display = XtDisplay (toplevel);

    /*XtSetArg (arg[0], XtNwidth, WIDTH+40);*/
    outer = XtCreateManagedWidget ("vpaned", vPanedWidgetClass,
				   toplevel, arg, 1);
    initGC(outer);

    initButtons (outer);

    ;
    has_color = findcmapVisual(XDefaultScreenOfDisplay(display));

    if(argc > 1 && strcmp(argv[1], "-c", 2) == 0) {
	maincolor = 1;
	argc--;
	argv++;
    }

    if(argc > 1 && strcmp(argv[1], "-mono", 3) == 0) {
	has_color = 0;
	argc--;
	argv++;
    }

    initCbar (outer);

    initBoxes (outer);
    XtRealizeWidget (toplevel);

    if (has_color) {
	initLut();
	if(visual != XDefaultVisual(display, XDefaultScreen(display)))
		maincolor = 0;

	color_map = maincolor ?
			DefaultColormap(display, XDefaultScreen(display)) :
			XCreateColormap (display, XtWindow (toplevel),
			    visual, AllocAll);
	XSetWindowColormap (display, XtWindow (toplevel), color_map);
	XStoreColors (display, color_map, save, 4);
	updateCmap(0, XSCALE-1);
    }

    if(argc <= 1) {
	reset_boxes();
    } else {
	file_load(argv[1]);
    }

    XtMainLoop ();
}

findcmapVisual(s)
	Screen *s;
{
	register int i, j;
	register Visual *v;
	register Depth *d;

#ifdef notdef
	/* This would be nice, but how do we get to run on the selected visual?? */
	for(i = 0; i < s->ndepths; i++) {
	    d = &s->depths[i];
	    for(j = 0; j < d->nvisuals; j++) {
		v = &d->visuals[j];
		if(v->class == PseudoColor && v->bits_per_rgb >= 4
					   && v->map_entries >= 256) {
			visual = v;
			return 1;
		}
	    }
	}
	visual = XDefaultVisualOfScreen(s);
	return 0;

#else
	visual = XDefaultVisualOfScreen(s);
	return (visual->class == PseudoColor
		&& visual->bits_per_rgb >= 4
		&& visual->map_entries >= 256);
#endif
}


void
quit()
{
	exit(0);
}

void
initGC(w)
    Widget	w;
{
    XGCValues	gcv;
    register int i;
    unsigned long pix[2];

    pix[0] = WhitePixel(display, DefaultScreen(display));
    pix[1] = BlackPixel(display, DefaultScreen(display));
    for(i = 0; i <= 1; i++) {
#define GC_wewant GCForeground|GCBackground|GCLineWidth|GCLineStyle|GCCapStyle|GCJoinStyle|GCFillStyle
	gcv.foreground = pix[i];
	gcv.background = pix[1-i];
	gcv.line_width = 0;
	gcv.line_style = LineSolid;
	gcv.cap_style = CapNotLast;
	gcv.join_style = JoinMiter;
	gcv.fill_style = FillSolid;
	gc_w1[i] = XtGetGC(w, GC_wewant, &gcv);
	gcv.line_width = 2;
	gc_w2[i] = XtGetGC(w, GC_wewant, &gcv);
    }
}

void
updateCmap (lox, hix)
    int lox, hix;	/* Span of colormap which changed (internal coords) */
{
    int lomap, himap;

    lomap = lox * 256 / XSCALE;
    himap = hix * 256 / XSCALE;
    if(lomap < 2)
	lomap = 2;
    if (has_color && himap >= lomap)
	XStoreColors (display, color_map, &lut[lomap], himap-lomap+1);

#ifndef NOPIXAR
    if (pixar)
	loadPixar();
#endif /*has PIXAR*/
}

void
initLut()
{
    register int i;

    for (i = 0; i < 256; i++) {
	lut[i].pixel = i;
	lut[i].flags = DoRed | DoGreen | DoBlue;
    }
}
