#include	<stdio.h>
#include	<math.h>
#include	"cmap.h"
#include	<X11/Label.h>
#include	<X11/Box.h>
#include	<X11/Scroll.h>

/*
 * Draw a batch of lines in a box.
 * Lines determined by a sequence of points which are assumed already
 * transformed to graphics coordinates.  (is this a good idea? for splines,
 * the caller needs to know the transformation anyway to compute a good fit.
 * So maybe it's reasonable to have the caller do the transformation.
 * On the other hand it's too X-specific to use XPoint as an interface.)
 */
void
putlines (box, p, npts, on)
    int		box;
    XPoint	*p;
    int		npts;
    int		on;
{
    Widget	wid	= cbox[box].boxws;
    Window	drawwin = XtWindow (wid);
    Display	*dpy	= XtDisplay (wid);

    XDrawLines(dpy, drawwin, on ? gc_fg1 : gc_bg1, p, npts, CoordModeOrigin);
}

/*
 * Plot a batch of control points in a given box.
 * Points assumed to have already been transformed to graphics coordinates.
 */
void
putpoints (box, p, npts, on)
    int		box;
    XPoint	*p;
    int		npts;
    int		on;
{
    Widget	wid	= cbox[box].boxws;
    Window	drawwin = XtWindow (wid);
    Display	*dpy	= XtDisplay (wid);
    register int i;

    for(i = 0; i < npts; i++) {
	XDrawRectangle (dpy, drawwin, on ? gc_fg2 : gc_bg2,
				p[i].x-2, p[i].y-2, 5, 5);
    }

}
