/* SCCS @(#)select2planeI.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                        select2planeI.layout.c                        */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   select2planeI.layout.c                              */
/*                                                                      */
/* DESCRIPTION  :   2 Input planes                                      */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "select2planeI.layout.h"
#include "widgetstructure.h"

#define MAX_ARGS 100

extern XmFontList gFontlist;
extern Pixel      gorchid, gthistle;

/********************************************************
/   Creation Function for Selection2Planes 
/*******************************************************/

Widget
build_Selection2Planes(select2planeinput, IO_load_image_plane_OK, message1, message2, numplan)
	Widget select2planeinput;
	Widget IO_load_image_plane_OK;
        char *message1;
        char *message2;
	int numplan;
{
	Widget Selection2Planes;
	Widget Select2Plane0;
	Widget Select2Plane1;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Selection2Planes Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx,1); n++;

	Selection2Planes = 
	   XmCreateRowColumn(select2planeinput,"Selection2Planes",args,n);
	XtManageChild(Selection2Planes);

	/* Creating Select2Plane0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[73],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Select2Plane0 = XmCreateLabel(Selection2Planes,"Select2Plane0",args,n);
	XtManageChild(Select2Plane0);

	/* Creating Select2Plane1 Widget */ 

	Select2Plane1 = 
	   build_Select2Plane1(Selection2Planes,
		       IO_load_image_plane_OK, message1, message2, numplan);

	return(Selection2Planes);
}


/********************************************************
/   Creation Function for Select2Plane1 
/*******************************************************/

Widget
build_Select2Plane1(Selection2Planes, IO_load_image_plane_OK, message1, message2, numplan)
	Widget Selection2Planes;
	Widget IO_load_image_plane_OK;
        char *message1;
        char *message2;
	int numplan;
{
	Widget Select2Plane1;
	Widget Select2PlaneLabel1;
	Widget SelectPlanesRe;
	Widget SelectPlanesI;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Select2Plane1 Widget */ 


	Select2Plane1 = 
	   XmCreateRowColumn(Selection2Planes,"Select2Plane1",NULL,0);
	XtManageChild(Select2Plane1);

	/* Creating Select2PlaneLabel1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList,gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[102],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Select2PlaneLabel1 = 
	   XmCreateLabel(Select2Plane1,"Select2PlaneLabel1",args,n);
	XtManageChild(Select2PlaneLabel1);

	/* Creating SelectPlanesRe Widget */ 

	if (numplan == 2) /*aux_arithm_op_fourp*/
	  SelectPlanesRe = 
		build_SelectPlanesRe(Select2Plane1, 
				     IO_load_image_plane_OK, message1, 3);
	else
	  SelectPlanesRe = 
		build_SelectPlanesRe(Select2Plane1, 
				     IO_load_image_plane_OK, message1, 1);

	/* Creating SelectPlanesI Widget */ 

	if (numplan == 2)   /*aux_arithm_op_fourp*/
	   SelectPlanesI = 
		build_SelectPlanesI(Select2Plane1, 
				    IO_load_image_plane_OK, message2, 4);
	else
	   SelectPlanesI = 
		build_SelectPlanesI(Select2Plane1, 
				    IO_load_image_plane_OK, message2, 2);

	return(Select2Plane1);
}


/********************************************************
/   Creation Function for SelectPlanesRe 
/*******************************************************/

Widget
build_SelectPlanesRe(Select2Plane1, IO_load_image_plane_OK, message, numplan)
	Widget Select2Plane1;
	Widget IO_load_image_plane_OK;
        char *message;
	int numplan;
{
	Widget SelectPlanesRe;
	Widget SelectPlaneRLabel2;
	Widget PlaneRnumbers;
	Widget Plane[MAX_IMAGE];
	plan_image_select *Tableau_plans;
	char num[4];
	Arg args[MAX_ARGS];
	int i, n;

	/* Creating SelectPlanesRe Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	SelectPlanesRe = 
	    XmCreateRowColumn(Select2Plane1,"SelectPlanesRe",args,n);
	XtManageChild(SelectPlanesRe);

	/* Creating SelectPlaneRLabel2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList,gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
			XmSTRING_DEFAULT_CHARSET)); n++;

	SelectPlaneRLabel2 = 
	    XmCreateLabel(SelectPlanesRe,"SelectPlaneRLabel2",args,n);
	XtManageChild(SelectPlaneRLabel2);

	/* Creating PlaneRnumbers Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	PlaneRnumbers = XmCreateForm(SelectPlanesRe,"PlaneRnumbers",args,n);
	XtManageChild(PlaneRnumbers);

	/* Creating Plane[MAX_IMAGE] Widgets */ 
	Tableau_plans = 
	    (plan_image_select *) malloc (sizeof (plan_image_select));

	for (i=0;i < MAX_IMAGE; i++){
	  itoa (i, num);	 
	  n = 0;
	  XtSetArg(args[n],XmNfontList,gFontlist); n++;
	  if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	  else
	  {
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	    XtSetArg(args[n],XmNleftWidget,Plane[i-1]);
	  }
	  n++;
	  XtSetArg(args[n],XmNwidth, 20); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	  XtSetArg(args[n],XmNrecomputeSize,false); n++;
	  XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	  /* Definition de l'occupation du plan represente par ce bouton!*/
	  if (Occupation_Plan(i) == 1){
	    XtSetArg (args[n],XmNforeground, gorchid); n++;
	  }
	  XtSetArg (args[n],XmNbackground, gthistle);n++;


	  Plane[i] = XmCreateDrawnButton(PlaneRnumbers,"Plane",args,n);
	  XtManageChild(Plane[i]);
	  
	  Tableau_plans->plan_image[i] = Plane[i];
	}

	Tableau_plans->num_index = numplan;

	  /* Adding Callbacks for Plane[i] */ 

	for (i=0;i < MAX_IMAGE; i++)
	  XtAddCallback(Plane[i],
		XmNactivateCallback, plane_selected,Tableau_plans);

	XtAddCallback(IO_load_image_plane_OK,XmNactivateCallback,
		      libere_memoire,Tableau_plans);

	return(SelectPlanesRe);
}


/********************************************************
/   Creation Function for SelectPlanesI 
/*******************************************************/

Widget
build_SelectPlanesI(Select2Plane1, IO_load_image_plane_OK, message, numplan)
	Widget Select2Plane1;
	Widget IO_load_image_plane_OK;
        char *message;
	int numplan;
{
	Widget SelectPlanesI;
	Widget SelectPlaneILabel2;
	Widget PlaneInumbers;
	Widget Plane[MAX_IMAGE];
	plan_image_select *Tableau_plans;
	char num[4];
	Arg args[MAX_ARGS];
	int i, n;

	/* Creating SelectPlanesI Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	SelectPlanesI = 
	    XmCreateRowColumn(Select2Plane1,"SelectPlanesI",args,n);
	XtManageChild(SelectPlanesI);

	/* Creating SelectPlaneILabel2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList,gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
			XmSTRING_DEFAULT_CHARSET)); n++;

	SelectPlaneILabel2 = 
	    XmCreateLabel(SelectPlanesI,"SelectPlaneILabel2",args,n);
	XtManageChild(SelectPlaneILabel2);

	/* Creating PlaneInumbers Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	PlaneInumbers = XmCreateForm(SelectPlanesI,"PlaneInumbers",args,n);
	XtManageChild(PlaneInumbers);

	/* Creating Plane[MAX_IMAGE] Widgets */ 
	Tableau_plans = 
	    (plan_image_select *) malloc (sizeof (plan_image_select));

	for (i=0;i < MAX_IMAGE; i++){
	  itoa (i, num);	 
	  n = 0;
	  XtSetArg(args[n],XmNfontList,gFontlist); n++;
	  if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	  else
	  {
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	    XtSetArg(args[n],XmNleftWidget,Plane[i-1]);
	  }
	  n++;
	  XtSetArg(args[n],XmNwidth, 20); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	  XtSetArg(args[n],XmNrecomputeSize,false); n++;
	  XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	  /* Definition de l'occupation du plan represente par ce bouton!*/
	  if (Occupation_Plan(i) == 1){
	    XtSetArg (args[n],XmNforeground, gorchid); n++;
	  }
	  XtSetArg (args[n],XmNbackground, gthistle);n++;


	  Plane[i] = XmCreateDrawnButton(PlaneInumbers,"Plane",args,n);
	  XtManageChild(Plane[i]);
	  
	  Tableau_plans->plan_image[i] = Plane[i];
	}

	Tableau_plans->num_index = numplan;

	  /* Adding Callbacks for Plane[i] */ 

	for (i=0;i < MAX_IMAGE; i++)
	  XtAddCallback(Plane[i],
		XmNactivateCallback, plane_selected,Tableau_plans);

	XtAddCallback(IO_load_image_plane_OK,XmNactivateCallback,
		      libere_memoire,Tableau_plans);


	return(SelectPlanesI);
}
