/* SCCS @(#)LaboGel1D.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      LaboGel1D.callback.c                            */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   LaboGel1D.callback.c                                */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Gel1D Tool)                              */
/*                                                                      */
/* AUTHORS      :   Thierry PUN, Krassimir TODOROV, Marianne Logean     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "libwidgets/widgetstructure.h"
#include "pre_pro.layout.h"
#include "LaboGel1D.layout.h"
#include "gel1D_in4.h"
#include "../i_olim.layout.h"
#include "define.h"
#include "global.h"


extern Widget QUIT_Gel1D;
extern Widget Menu_Gel1D;

void
initial_data_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  Widget saisie_param;
  
  if (flag_help_only){
         hproc_gel_donnees_init();
	 return;
  }
  if (flag_help) hproc_gel_donnees_init();
  saisie_param = build_PRE_PRO_options_widget(w, 300, panel_titres[210]);
  XtManageChild(saisie_param);
}


void
show_gel_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_affiche_gel1d();
	 return;
  }
  if (flag_help) hproc_affiche_gel1d();
  proc_gel1d (41, NULL);
}

void
preestimated_calc_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_calculFronPreEst();
	 return;
  }
  if (flag_help) hproc_gel_calculFronPreEst();
  proc_gel1d (10, NULL);
  
}


void
preestimated_show_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_affichFronPreEst();
	 return;
  }
  if (flag_help) hproc_gel_affichFronPreEst();
  proc_gel1d (11, NULL);
}


void
preestimated_man_corr1_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_AjoutBand_CorrectMan();
	 return;
  }
  if (flag_help) hproc_gel_AjoutBand_CorrectMan();
  proc_gel1d(12, NULL);
}


void
preestimated_man_corr2_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_SupprimeBand_CorrectMan();
	 return;
  }
  if (flag_help) hproc_gel_SupprimeBand_CorrectMan();
  proc_gel1d(13, NULL);
}


void
preestimated_man_corr3_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_DeplaceFrontiere_CorrectMan();
	 return;
  }
  if (flag_help) hproc_gel_DeplaceFrontiere_CorrectMan();
  proc_gel1d(14, NULL);
}


void
precise1_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_calculFronPrecises();
	 return;
  }
  if (flag_help) hproc_gel_calculFronPrecises();
  proc_gel1d (20, NULL);
}

void
precise2_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_affichFronPrecises();
	 return;
  }
  if (flag_help) hproc_gel_affichFronPrecises();
  proc_gel1d (21, NULL);
}


void
precise3_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
           ;
	 return;
  }
  if (flag_help) ;
  proc_gel1d(22, NULL);
}


void
band_prof1_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_calculProfilBand();
	 return;
  }
  if (flag_help) hproc_gel_calculProfilBand();
  proc_gel1d(30, NULL);
  
}


void
band_prof2_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_affichGelIdeal();
	 return;
  }
  if (flag_help) hproc_gel_affichGelIdeal();
  proc_gel1d(31, NULL);

}

void
band_prof3_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_GelUnprofil();
	 return;
  }
  if (flag_help) hproc_gel_GelUnprofil();
  proc_gel1d(32, NULL);
}


void
smoothing_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{

  if (flag_help_only){
         hproc_gel_lisser();
	 return;
  }
  if (flag_help) hproc_gel_lisser();
/*proc_gel1d(42, Parami);*/
  
}


void
peaks1_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
        hproc_gel_RechercheAuto_EvalPic();
	 return;
  }
  if (flag_help) hproc_gel_RechercheAuto_EvalPic();
  proc_find_max_gel(1);
}

void
peaks2_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_AjoutPic_EvalPic();
	 return;
  }
  if (flag_help) hproc_gel_AjoutPic_EvalPic();
  proc_find_max_gel(2);
}

void
peaks3_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_SupprimePic_EvalPic();
	 return;
  }
  if (flag_help) hproc_gel_SupprimePic_EvalPic();
  proc_find_max_gel(3);
}

void
peaks4_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_SupprimePicConsec_EvalPic();
	 return;
  }
  if (flag_help) hproc_gel_SupprimePicConsec_EvalPic();
  proc_find_max_gel(4);
}

void
peaks5_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_SpecifieQuantMat_EvalPic();
	 return;
  }
  if (flag_help) hproc_gel_SpecifieQuantMat_EvalPic();
  proc_find_max_gel(5);
}

void
peaks6_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_ParamRecherche_EvalPic();
	 return;
  }
  if (flag_help) hproc_gel_ParamRecherche_EvalPic();
  proc_find_max_gel(6);
}

void
peaks7_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_gel_SauvegardePic_EvalPic();
	 return;
  }
  if (flag_help) hproc_gel_SauvegardePic_EvalPic();
  proc_find_max_gel(7);
}


void
read_prepro_standard_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
Widget IO_load_prepro_gel;
  if (flag_help_only){
         hproc_read_gel1d();
	 return;
  }
  if (flag_help) hproc_read_gel1d();

IO_load_prepro_gel = 
	build_IO_load_image_file_widget(w, 7, mastertabs[50]);
XtManageChild(IO_load_prepro_gel);
/*  read_gel1d_proc(fn);  /*cf lecture standard*/
}


void
read_prepro_melanie_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
Widget IO_load_prepro_gel;
  if (flag_help_only){
         hproc_read_gel1d();
	 return;
  }
  if (flag_help) hproc_read_gel1d();

IO_load_prepro_gel = 
	build_IO_load_image_file_widget(w, 8, mastertabs[50]);
XtManageChild(IO_load_prepro_gel);
/*  read_gel1d_proc(fn);  /*cf lecture standard*/
}


void
save_standard_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_write_gel1d();
	 return;
  }
  if (flag_help) hproc_write_gel1d();
  write_gel1d_proc(1);
}


void
save_melanie_actcall(w, clientData, callData)
	Widget w;
	caddr_t clientData;
	caddr_t callData;
{
  if (flag_help_only){
         hproc_write_gel1d();
	 return;
  }
  if (flag_help) hproc_write_gel1d();
  write_gel1d_proc(2);
}

/******************************************************
/   activateCallback for Widget  QUIT
/*****************************************************/

void
QUIT_Gel1D_actcall(QUIT, Quit_Gel1D, callData)
	Widget QUIT;
	Widget Quit_Gel1D;
	caddr_t callData;
{
XtManageChild (Quit_Gel1D);
}



void
Cancel_Gel1D(Quit_Gel1D, clientData, callData)
	Widget Quit_Gel1D;
	caddr_t clientData;
	caddr_t callData;
{
XtUnmanageChild (Quit_Gel1D);
}




void
OKquitgel1d(Quit_Gel1D, clientData, callData)
	Widget Quit_Gel1D;
	caddr_t clientData;
	caddr_t callData;
{
proc_sortie_gel1d();
XtUnmanageChild (Menu_Gel1D);
XtUnmanageChild (Quit_Gel1D);
XtUnmanageChild (QUIT_Gel1D);
}


