// schroede.h
/*
 * SPKitSchroederReverb: the schroeder reverberator class
 * Copyright (c) 1995 Janne Halmkrona
 */

#ifndef _SPKIT_SCHROEDER_H_
#define _SPKIT_SCHROEDER_H_

#include "processo.h"
#include "comb.h"
#include "allpassn.h"

class SPKitSchroederReverb : public SPKitProcessor {
public:
    SPKitSchroederReverb();
        
    int setInput(SPKitProcessor* input);
    void setReverbTime(SPKitFloat rt);

    SPKitFloat getReverbTime() const;

protected:
    SPKitFloat reverbTime;

    SPKitMux mux;
    SPKitComb comb1;
    SPKitComb comb2;
    SPKitComb comb3;
    SPKitComb comb4;
    SPKitSum sum;
    SPKitAmp amp;
    SPKitAllPassNetwork allpass1;
    SPKitAllPassNetwork allpass2;
   };

inline SPKitSchroederReverb::SPKitSchroederReverb()
{
    reverbTime = 1.0;
}

inline SPKitFloat SPKitSchroederReverb::getReverbTime() const
{
    return reverbTime;
}

#endif

