// schroede.cc
/*
 * schroeder: the schroeder reverberator class
 * Copyright (c) 1995 Janne Halmkrona
 */

#include "schroede.h"

int SPKitSchroederReverb::setInput(SPKitProcessor *ip)
{
    mux.setInput(ip);
    comb1.setInputAndDelayTime(&mux, 0.0297);
    comb2.setInputAndDelayTime(&mux, 0.0371);
    comb3.setInputAndDelayTime(&mux, 0.0411);
    comb4.setInputAndDelayTime(&mux, 0.0437);
    sum.setInput(&comb1);
    sum.addInput(&comb2);
    sum.addInput(&comb3);
    sum.addInput(&comb4);
    amp.setInput(&sum);
    amp.setGain(0.25);
    allpass1.setInputAndDelayTime(&amp, 0.005);
    allpass2.setInputAndDelayTime(&allpass1, 0.0017);
       
    return SPKitProcessor::setInput(&allpass2);
}

void SPKitSchroederReverb::setReverbTime(SPKitFloat rt)
{
    reverbTime = rt;

    comb1.setReverbTime(reverbTime);
    comb2.setReverbTime(reverbTime);
    comb3.setReverbTime(reverbTime);
    comb4.setReverbTime(reverbTime);

    allpass1.setReverbTime(0.096835);
    allpass2.setReverbTime(0.032924);
}
