// processo.h
/*
	Copyright (c) 1994 Kai Lassfolk
*/

#ifndef _SPKIT_PROCESSOR_H_
#define _SPKIT_PROCESSOR_H_

extern "C" {
#include "machine.h"
}

typedef double SPKitSample;
typedef double SPKitFloat;
typedef int SPKitInt;
typedef int SPKitError;

class SPKitProcessor {
public:
    SPKitProcessor();
    virtual ~SPKitProcessor();
    
    virtual SPKitError setInput(SPKitProcessor*);
    virtual void setOutput(SPKitProcessor*);
    
    virtual SPKitProcessor* getInput() const;
    SPKitProcessor* getOutput() const;
    virtual SPKitFloat getSamplingRate() const;
    virtual SPKitInt getChannelCount() const;
    SPKitInt getOriginalDataFormat() const;

    virtual int getSample(SPKitSample&);

protected:
    SPKitProcessor* input;
    SPKitProcessor* output;
    SPKitFloat inputSamplingRate;
    SPKitInt inputChannelCount;
    SPKitInt originalDataFormat;
};

inline SPKitProcessor::~SPKitProcessor()
{
}

inline SPKitProcessor* SPKitProcessor::getInput() const
{
    return input;
}

inline SPKitProcessor* SPKitProcessor::getOutput() const
{
    return output;
}

inline SPKitFloat SPKitProcessor::getSamplingRate() const
{
    return inputSamplingRate;
}

inline SPKitInt SPKitProcessor::getChannelCount() const
{
    return inputChannelCount;
}

inline SPKitInt SPKitProcessor::getOriginalDataFormat() const
{
    return originalDataFormat;
}

inline int SPKitProcessor::getSample(SPKitSample& outputSample)
{
    return input->getSample(outputSample);
}

inline void SPKitProcessor::setOutput(SPKitProcessor* sp)
{
    output = sp;
}

#endif
