// mux.cc

#include "mux.h"

SPKitError SPKitMux::setInput(SPKitProcessor* p)
{
    if (SPKitProcessor::setInput(p) != 0)
	return -1;

    outputCount = outputIndex = endOfInput = 0;
    inputSample = 0.0;

    return 0;
}

void SPKitMux::setOutput(SPKitProcessor* sp)
{
    SPKitProcessor::setOutput(sp);
    
    outputCount++;
}

int SPKitMux::getSample(SPKitSample& outputSample)
{
    if (endOfInput)
	return 0;

    if (outputIndex >= outputCount)
	outputIndex = 0;

    if (outputIndex++ == 0)
	if (input->getSample(inputSample) == 0) {
	    endOfInput = 1;
	    return 0;
	}

    outputSample = inputSample;

    return 1;
}
