/* header.h */
/*
	Copyright (c) 1994 Kai Lassfolk
*/

#ifndef _SNDHEADER_H__
#define _SNDHEADER_H__

#include "machine.h"
#include "swapbyte.h"

typedef struct {
    int32 magicNumber;
    int32 headerSize;
    int32 dataSize;
    int32 dataFormat;
    int32 samplingRate;
    int32 channelCount;
    int8 info[4];
} SndHeader;

SndHeader *newSndHeader(double samplingRate, int channelCount, int dataFormat);
int getSndHeader(SndHeader **hp, FILE *fp);
int putSndHeader(SndHeader *hp, FILE *fp);

#define SND_MAGIC_NUMBER	((uint32) 0x2e736e64)
#define SND_MAGIC_STRING	".snd"

#define SND_DATA_FORMAT_UNKNOWN		(0)
#define SND_DATA_FORMAT_MULAW_8		(1)
#define SND_DATA_FORMAT_LINEAR_8	(2)
#define SND_DATA_FORMAT_LINEAR_16	(3)
#define SND_DATA_FORMAT_LINEAR_24	(4)
#define SND_DATA_FORMAT_LINEAR_32	(5)
#define SND_DATA_FORMAT_FLOAT		(6)
#define SND_DATA_FORMAT_DOUBLE		(7)

#endif
