// genwrite.cc

#include "genwrite.h"
#include <stdio.h>
extern "C" {
#include <limits.h>
};

SPKitWriter::SPKitWriter()
{
    fileHeader = 0;
}

SPKitWriter::~SPKitWriter()
{
    if (fileHeader)
	free(fileHeader);
}

int SPKitWriter::setInputOutput(SPKitProcessor* sp, const char* fname)
{
    samplesWritten = 0;
    
    if (SPKitProcessor::setInput(sp))
	return -1;

    if ((fileHeader = newSndHeader(inputSamplingRate,
				   inputChannelCount,
				   SND_DATA_FORMAT_LINEAR_16)) == 0)
	return -1;

    if ((filePtr = fopen(fname, "wb")) == 0)
	return -1;

    putSndHeader(fileHeader, filePtr);

    return 0;
}

void SPKitWriter::run()
{
    SPKitSample inputSample;

    while (input->getSample(inputSample)) {
#ifdef __LITTLE_ENDIAN__
	uint16 outputSample;
	if (inputSample < -1.0)
	    outputSample = swapInt16(SHRT_MIN);
	else if (inputSample > 1.0)
	    outputSample = swapInt16(SHRT_MAX);
	else
	    outputSample = swapInt16(inputSample * SHRT_MAX);
	samplesWritten += fwrite(&outputSample, sizeof(uint16), 1, filePtr);
#else
	int16 outputSample;
	if (inputSample < -1.0)
	    outputSample = SHRT_MIN;
	else if (inputSample > 1.0)
	    outputSample = SHRT_MAX;
	else
	    outputSample = int16(inputSample * SHRT_MAX);
	samplesWritten += fwrite(&outputSample, sizeof(int16), 1, filePtr);
#endif
//	printf("%lg\n", inputSample);
    }

    fileHeader->dataSize = samplesWritten * sizeof(int16);
    fseek(filePtr, 0, SEEK_SET);
    putSndHeader(fileHeader, filePtr);

    fclose(filePtr);
}

int SPKitWriter::runFor(int count)
{
    static int inputRetVal;
    SPKitSample inputSample;
    short outputSample;
    int i = count;

    while ((inputRetVal = input->getSample(inputSample)) || i--) {
#ifdef __LITTLE_ENDIAN__
	if (inputSample < -1.0)
	    outputSample = swapInt16(SHRT_MIN);
	else if (inputSample > 1.0)
	    outputSample = swapInt16(SHRT_MAX);
	else
	    outputSample = swapInt16((inputSample * SHRT_MAX));
#else
	if (inputSample < -1.0)
	    outputSample = SHRT_MIN;
	else if (inputSample > 1.0)
	    outputSample = SHRT_MAX;
	else
	    outputSample = short(inputSample * SHRT_MAX);
#endif
	samplesWritten += fwrite(&outputSample, sizeof(int16), 1, filePtr);
    }
    
    if (!inputRetVal) {
	fileHeader->dataSize = samplesWritten * sizeof(int16);
	fseek(filePtr, 0, SEEK_SET);
	putSndHeader(fileHeader, filePtr);
    	fclose(filePtr);
    }
    
    return count - i;
}
