// genreade.cc

#include "genreade.h"
extern "C" {
#include "header.h"
#include <limits.h>
};

SPKitSample SPKitReader::shrtMaxDenom = 1.0;

SPKitReader::SPKitReader()
{
    filePtr = NULL;
}

SPKitReader::~SPKitReader()
{
    if (filePtr != NULL)
	fclose(filePtr);
}

SPKitError SPKitReader::setInput(const char* soundFile)
{
    SndHeader *soundStruct;

    shrtMaxDenom = 1.0 / SPKitSample(SHRT_MAX);

    if ((filePtr = fopen(soundFile, "r")) == NULL)
	return -1;
		
    soundStruct = new SndHeader;

    getSndHeader(&soundStruct, filePtr);
    inputSamplingRate = soundStruct->samplingRate;
    inputChannelCount = soundStruct->channelCount;
    originalDataFormat = soundStruct->dataFormat;
    samplesLeft = sampleCount = soundStruct->dataSize / sizeof(short);

#ifdef DEBUG
    printf("Header size: %ld\n", soundStruct->headerSize);
    printf("Header channel count: %ld\n", soundStruct->channelCount);
    printf("Header sampling rate: %ld\n", soundStruct->samplingRate);
#endif

    delete soundStruct;
	    
    return 0;
}


int SPKitReader::getSample(SPKitSample& outputSample)
{
#ifdef __LITTLE_ENDIAN__
    int16 inputSample;
    
    if (fread(&inputSample, sizeof(int16), 1, filePtr) <= 0)
	    return 0;
    outputSample = (int16)swapInt16(inputSample) * shrtMaxDenom;
#else
    int16 inputSample;
    
    if (fread(&inputSample, sizeof(int16), 1, filePtr) <= 0)
	    return 0;
    outputSample = inputSample * shrtMaxDenom;
#endif
//    printf("%lg\n", outputSample);
    samplesLeft--;
    return 1;
}
