// gate.cc

#include "gate.h"

void SPKitGate::scaleBuffer()
{
    SPKitSample scale;
    SPKitSample scale1;
    SPKitSample scale2;
    SPKitSample scaleIncrement;
    int i = writeIndex;
    
    if (absMax1 >= threshold && absMax2 >= threshold)
	return;
	
    if (absMax1 < threshold)
	scale1 = 0.0;
    else
	scale1 = 1.0;
    if (absMax2 < threshold)
	scale2 = 0.0;
    else
	scale2 = 1.0;

    scaleIncrement = (scale2 - scale1) / (inputBufSize
		    / inputChannelCount);
    
    scale = scale1;
    while (i != processIndex) {
	sampleBuffer[i] *= scale;
	i++;
	i %= bufSize;
	if (i % inputChannelCount == 0)
	    scale += scaleIncrement;
    }
}
