// comb.cc
/*
 * comb: the comb filter class
 * Copyright (c) 1995 Janne Halmkrona
 */

#include <math.h>
#include "comb.h"


int SPKitComb::setInputAndDelayTime(SPKitProcessor *ip, SPKitFloat dt)
{
	delayTime = dt;	

    	feedback.setInput(ip);
    	feedback.setFeedbackTime(0.0);

    	fbdelay.setInputAndDelayTime(&feedback, delayTime);
    	mux.setInput(&fbdelay);
    	amp.setInput(&mux);
    	
	feedback.setFeedbackInput(&amp);

	return SPKitProcessor::setInput(&mux);
}

void SPKitComb::setReverbTime(SPKitFloat value)
{
	reverbTime = value;
	g = pow(0.001, (delayTime / reverbTime));

	feedback.setFeedbackTime(reverbTime);
	amp.setGain(g);

}

