// bwbandre.cc

#include "bwbandre.h"
#include <math.h>

void SPKitBWBandRejectFilter::setCenterFreqAndBW(SPKitFloat f, SPKitFloat bw)
{
    centerFreq = f;
    bandwidth = bw;
    
    C = tan(M_PI * bandwidth / inputSamplingRate);
    D = 2 * cos(2 * M_PI * centerFreq / inputSamplingRate);

    a[0] = 1.0 / (1.0 + C);
    a[1] = -D * a[0];
    a[2] = a[0];

    b[0] = a[1];
    b[1] = (1.0 - C) * a[0];
}
