// bwbandpa.cc

#include "bwbandpa.h"
#include <math.h>

void SPKitBWBandPassFilter::setCenterFreqAndBW(SPKitFloat f, SPKitFloat bw)
{
    centerFreq = f;
    bandwidth = bw;
    
    C = 1.0 / tan(M_PI * bandwidth / inputSamplingRate);
    D = 2 * cos(2 * M_PI * centerFreq / inputSamplingRate);

    a[0] = 1.0 / (1.0 + C);
    a[1] = 0.0;
    a[2] = -a[0];

    b[0] = -C * D * a[0];
    b[1] = (C - 1.0) * a[0];
}
