// butterwo.cc

#include "butterwo.h"
#include <math.h>

SPKitError SPKitButterworthFilter::setInput(SPKitProcessor* sp)
{
    channelIndex = 0;

    SPKitProcessor::setInput(sp);

    for (int i = 0; i < inputChannelCount; i++) {
    	chBuf[i] = new BWBuffer;
    	chBuf[i]->x[0] = chBuf[i]->x[1] = 0.0;
	chBuf[i]->y[0] = chBuf[i]->y[1] = 0.0;
    }

    return 1;
}

int SPKitButterworthFilter::getSample(SPKitSample& outputSample)
{
    SPKitSample inputSample;

    if (!input->getSample(inputSample))
    	return 0;

    BWBuffer* buf = chBuf[channelIndex++];

    outputSample = a[0] * inputSample + a[1] * buf->x[0] + a[2] * buf->x[1]
    		   - b[0] * buf->y[0] - b[1] * buf->y[1];

    buf->x[1] = buf->x[0];
    buf->x[0] = inputSample;
    buf->y[1] = buf->y[0];
    buf->y[0] = outputSample;

    channelIndex %= inputChannelCount;

    return 1;
}

SPKitButterworthFilter::~SPKitButterworthFilter()
{
    for (int i = 0; i < inputChannelCount; i++)
    	delete chBuf[i];
}
    
