// allpassn.h
/*
 * SPKitAllPassNetwork: an all-pass network class
 */
/*
    Copyright (c) 1995 Kai Lassfolk
*/

 
#ifndef _SPKIT_ALLPASSNETWORK_H_
#define _SPKIT_ALLPASSNETWORK_H_

#include "processo.h"
#include "feedback.h"
#include "mux.h"
#include "sum.h"
#include "amp.h"
#include "fbdelay.h"

class SPKitAllPassNetwork : public SPKitProcessor {
public:
    SPKitAllPassNetwork();
    
    virtual SPKitError setInputAndDelayTime(SPKitProcessor* ip, SPKitFloat dt);
    void setG(SPKitFloat newG);
    void setReverbTime(SPKitFloat rt);
    
    SPKitFloat getReverbTime() const;
    SPKitFloat getDelayTime() const;

protected:
    SPKitFloat reverbTime;
    SPKitFloat delayTime;
    SPKitFloat g;

    SPKitFeedback feedback;
    SPKitSum sum;
    SPKitFBDelay delay;
    SPKitAmp amp1;
    SPKitAmp amp2;
    SPKitAmp amp3;
    SPKitMux mux1;
    SPKitMux mux2;
};

inline SPKitFloat SPKitAllPassNetwork::getDelayTime() const
{
    return delayTime;
}


#endif
