// wshape.cc
/*
 * wshape: a waveshaping program
 *
 * Copyright (c) 1995 Kai Lassfolk
 */

#include <stdio.h>
#include <spkit/spkit.h>

int main(int argc, char *argv[])
{
    SPKitReader reader;
    SPKitReader bufReader;
    SPKitAmp inAmp;
    SPKitAmp outAmp;
    SPKitWaveShaper shaper;
    SPKitWriter writer;
    double inGain;
    double outGain;

    if (argc != 6) {
	fprintf(stderr, "Usage: wshape inputVolume outputVolume");
	fprintf(stderr, " shapefile sourcefile destfile\n");
	exit(1);
    }

    /*
     * Connect objects
     */
    reader.setInput(argv[4]); // Open source soundfile
    inAmp.setInput(&reader);  // Set reader as input to input amp
    
    bufReader.setInput(argv[3]); // Open transfer function file
    shaper.setInputAndBuffer(&inAmp, &bufReader);
    outAmp.setInput(&shaper);  // Set reader as input to fader
    
    writer.setInputOutput(&outAmp, argv[5]); // Set fader as input to writer
					    // and open destination soundfile
    /*
     * Setup processing parameters
     */
    sscanf(argv[1], "%lf", &inGain);
    inAmp.setGain(inGain); // Set amp gain

    sscanf(argv[2], "%lf", &outGain);
    outAmp.setGain(outGain);

    /*
     * Run
     */
    writer.run();

    exit(0);
}
