// testrev.cc
/*
 * testrev: a simple SPKit program to test the Schroeder reverberator
 * Copyright (c) 1995 Janne Halmkrona
 */

#include <stdio.h>
#include <spkit/spkit.h>
#include "schroeder.h"

main(int argc, char *argv[])
{
    SPKitReader reader;
    SPKitSchroederReverb schroeder;
    SPKitWriter writer;
    
    SPKitAmp ampDry;		// amp for dry, unprocessed sound
    SPKitAmp ampRev;		// amp for processed sound
    SPKitSum sum;		
    SPKitMux mux;		

    double time, mix;

    if (argc != 5) {
	    fprintf(stderr, "Usage: testrev revtime mix(0-1) source dest\n");
	    exit(1);
    }

    /*
     * Connect objects
     */
    reader.setInput(argv[3]); 		// Open source soundfile
    mux.setInput(&reader); 		// Set reader as input to multiplexer
    ampDry.setInput(&mux);		// Set multiplexer as input to dry amplifier
    schroeder.setInput(&mux); 		// Set multiplexer as input to schroeder reverberator
    ampRev.setInput(&schroeder);	// Set schroeder as input to reverbed amplifier

    sum.setInput(&ampDry);
    sum.addInput(&ampRev);
    
    writer.setInputOutput(&sum, argv[4]); 	// Set schroeder as input to writer
						// and open destination soundfile
    /*
     * Setup processing parameters
     */
    sscanf(argv[1], "%lf", &time);
    sscanf(argv[2], "%lf", &mix);
    ampRev.setGain(mix);		// Set amount (0-1) of reverbed sound in output
    ampDry.setGain(1-mix);		// Set amount of dry sound in output
    schroeder.setReverbTime(time); 	// Set reverb time

    /*
     * Run
     */
    writer.run();
    
    exit(0);
}


