// stdrever.h

#ifndef _SPKIT_STDREVERB_H_
#define _SPKIT_STDREVERB_H_

#include <spkit/spkit.h>

#include "comblowp.h"

class SPKitStdReverb : public SPKitProcessor {
public:
    SPKitError setInput(SPKitProcessor*);
    
    void setG(SPKitFloat newG);
    void setReverbTime(SPKitFloat rt);

protected:
    SPKitFloat loopTime;
    SPKitFloat reverbTime;

    SPKitMux mux;
    SPKitCombLowPass comb1;
    SPKitCombLowPass comb2;
    SPKitCombLowPass comb3;
    SPKitCombLowPass comb4;
    SPKitCombLowPass comb5;
    SPKitCombLowPass comb6;
    SPKitSum sum;
    SPKitAmp amp;
#if 1
    SPKitAllPassNetwork allpass;
#else
    SPKitAllPassNetwork ap1;
    SPKitAllPassNetwork ap2;
    SPKitAllPassNetwork ap3;
#endif
};

#endif
