// stdrever.cc

#include "stdrever.h"

SPKitError SPKitStdReverb::setInput(SPKitProcessor* ip)
{
    mux.setInput(ip);

    comb1.setInputAndDelayTime(&mux, 0.050);
    comb1.setG(0.83);
    comb1.setG1(0.24);

    comb2.setInputAndDelayTime(&mux, 0.056);
    comb2.setG(0.83);
    comb2.setG1(0.26);

    comb3.setInputAndDelayTime(&mux, 0.061);
    comb2.setG(0.83);
    comb3.setG1(0.28);

    comb4.setInputAndDelayTime(&mux, 0.068);
    comb4.setG(0.83);
    comb4.setG1(0.29);

    comb5.setInputAndDelayTime(&mux, 0.072);
    comb5.setG(0.83);
    comb5.setG1(0.30);

    comb6.setInputAndDelayTime(&mux, 0.078);
    comb6.setG(0.83);
    comb6.setG1(0.32);

    sum.setInput(&comb1);
    sum.addInput(&comb2);
    sum.addInput(&comb3);
    sum.addInput(&comb4);
    sum.addInput(&comb5);
    sum.addInput(&comb6);
    
    amp.setInput(&sum);
    amp.setGain(1.0/6.0);
    
#if 1
    allpass.setInputAndDelayTime(&amp, 0.006);
    allpass.setG(0.7);

    return SPKitProcessor::setInput(&allpass);
#else
    ap1.setInputAndDelayTime(&amp, 0.006);
    ap1.setG(0.7);
    ap2.setInputAndDelayTime(&ap1, 0.0091);
    ap2.setG(0.683);
    ap3.setInputAndDelayTime(&ap2, 0.0099);
    ap3.setG(0.721);

    return SPKitProcessor::setInput(&ap3);
#endif
}

void SPKitStdReverb::setReverbTime(SPKitFloat rt)
{
    reverbTime = rt;

    comb1.setReverbTime(reverbTime);
    comb2.setReverbTime(reverbTime);
    comb3.setReverbTime(reverbTime);
    comb4.setReverbTime(reverbTime);
    comb5.setReverbTime(reverbTime);
    comb6.setReverbTime(reverbTime);
}

void SPKitStdReverb::setG(SPKitFloat newG)
{
    comb1.setG(newG);
    comb2.setG(newG);
    comb3.setG(newG);
    comb4.setG(newG);
    comb5.setG(newG);
    comb6.setG(newG);
}
