// jamrever.h

#ifndef _SPKIT_JAMREVERB_H_
#define _SPKIT_JAMREVERB_H_

#include <spkit/spkit.h>
#include "stdrever.h"

class SPKitJAMReverb : public SPKitProcessor {
public:
    SPKitError setInput(SPKitProcessor* input);
    
    void setReverbLevel(SPKitFloat level);
    void setReverbTime(SPKitFloat time);

protected:
    // tap delay line:
    SPKitDelay pd1, pd2, pd3, pd4, pd5, pd6, pd7, pd8, pd9,
	       pd10, pd11, pd12, pd13, pd14, pd15, pd16, pd17, pd18;
    SPKitMux m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10,
	     m11, m12, m13, m14, m15, m16, m17;
    SPKitAmp a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10,
	     a11, a12, a13, a14, a15, a16, a17, a18;

    SPKitZ1LowPassFilter lpf;
    SPKitAmp lpfa;

    SPKitSum pdsum;
    SPKitMux pdmux;
    SPKitStdReverb reverb;
    SPKitDelay rd;
    SPKitAmp ra;
    SPKitSum outsum;
};

#endif
