// comblowp.cc

#include <math.h>
#include "comblowp.h"

SPKitCombLowPass::SPKitCombLowPass()
{
    reverbTime = 2.0;
    delayTime = 0.0;
    
    g = 0.83;
    g1 = 0.46;
    g2 = g * (1.0 - g1);
    
    feedback = 0;
    delay = 0;
    lpf = 0;
    amp = 0;
    mux = 0;
}

SPKitCombLowPass::~SPKitCombLowPass()
{
    if (feedback)
	delete feedback;
    if (delay)
	delete delay;
    if (lpf)
	delete lpf;
    if (amp)
	delete amp;
    if (mux)
	delete mux;
}

int SPKitCombLowPass::setInputAndDelayTime(SPKitProcessor* ip, SPKitFloat dt)
{
    delayTime = dt;	

    feedback = new SPKitFeedback;
    feedback->setInput(ip);
    feedback->setFeedbackTime(0.0);

    delay = new SPKitFBDelay;
    delay->setInputAndDelayTime(feedback, delayTime);

    mux = new SPKitMux;
    mux->setInput(delay);

    lpf = new SPKitZ1LowPassFilter;
    lpf->setInput(mux);
    lpf->setG(g1);

    amp = new SPKitAmp;
    amp->setInput(lpf);
    amp->setGain(g2);

    feedback->setFeedbackInput(amp);
    
    return SPKitProcessor::setInput(mux);
}

void SPKitCombLowPass::setG(SPKitFloat newG)
{
    if (newG <= 0.0)
	g = 0.00001;
    else if (newG >= 1.0)
	g = 0.99999;
    else
	g = newG;
    
    reverbTime = 0.2 / (1.0 - g); // Notice: 0.2 will work only at 44100 sr 
    feedback->setFeedbackTime(reverbTime);
    
    updateGains();
}
    
void SPKitCombLowPass::setG1(SPKitFloat newG1)
{
    if (newG1 <= 0.0)
	g1 = 0.00001;
    else if (newG1 >= 1.0)
	g1 = 0.99999;
    else
	g1 = newG1;
    
    updateGains();
}


void SPKitCombLowPass::setReverbTime(SPKitFloat value)
{
    reverbTime = value > 0.0 ? value : 0.0001;
    g = 1.0 - 0.2 / reverbTime;

    feedback->setFeedbackTime(reverbTime);

    updateGains();
}

void SPKitCombLowPass::updateGains()
{
    g2 = g * (1.0 - g1);
    
    lpf->setG(g1);
    amp->setGain(g2);
}
