// gate.cc
/*
 * gate: an SPKitGate example
 *
 * Copyright (c) 1995 Kai Lassfolk
 */

#include <stdio.h>
#include <spkit/spkit.h>

int main(int argc, char* argv[])
{
    SPKitReader reader;
    SPKitGate dyn;
    SPKitWriter writer;
    double threshold;
    double estimationTime;

    if (argc != 5) {
	fprintf(stderr, "Usage: gate threshold estimTime sourcefile destfile\n");
	return 1;
    }

    sscanf(argv[2], "%lf", &estimationTime);

    if (reader.setInput(argv[3]) < 0) {
	fprintf(stderr, "gate: cannot open input: %s\n", argv[3]);
	return 1;
    }
    dyn.setInputAndEstimationTime(&reader, estimationTime);
    if (writer.setInputOutput(&dyn, argv[4]) < 0) {
	fprintf(stderr, "gate: cannot open input: %s\n", argv[4]);
	return 1;
    }

    sscanf(argv[1], "%lf", &threshold);
    dyn.setThreshold(threshold);

    writer.run();

    return 0;
}

