// clim.cc
/*
 * clim: a compressor/limiter example
 *
 * Copyright (c) 1995 Kai Lassfolk
 */

#include <stdio.h>

#include <spkit/spkit.h>

int main(int argc, char* argv[])
{
    SPKitReader reader;
    SPKitAmp amp;
    SPKitCompressorLimiter compLim;
    SPKitWriter writer;

    double gain;
    double compThreshold;
    double compRatio;
    double limThreshold;

    if (argc != 7) {
	fprintf(stderr, "Usage: clim gain compressor-threshold comp-ratio");
	fprintf(stderr, " limiter-threshold sourcefile destfile\n");
	return 1;
    }

    if (reader.setInput(argv[5]) < 0) {
	fprintf(stderr, "clim: cannot open input: %s\n", argv[5]);
	return 1;
    }
    amp.setInput(&reader);
    compLim.setInputAndEstimationTime(&amp, 0.05);
    if (writer.setInputOutput(&compLim, argv[6]) < 0) {
	fprintf(stderr, "clim: cannot open output: %s\n", argv[6]);
	return 1;
    }

    sscanf(argv[1], "%lf", &gain);
    amp.setGain(gain);
    sscanf(argv[2], "%lf", &compThreshold);
    compLim.setCompressorThreshold(compThreshold);
    sscanf(argv[3], "%lf", &compRatio);
    compLim.setCompressionRatio(compRatio);
    sscanf(argv[4], "%lf", &limThreshold);
    compLim.setLimiterThreshold(limThreshold);

    writer.run();

    return 0;
}
