// brbw.cc
// brbw: a Butterworth band-reject filter example program
/*
	Copyright (c) 1994 Kai Lassfolk
*/

#include <stdio.h>
#include <spkit/spkit.h>

int main(int argc, char *argv[])
{
    SPKitReader source;
    SPKitBWBandRejectFilter brbw;
    SPKitWriter dest;
    double freq;
    double bw;

    if (argc != 5) {
	fprintf(stderr, "Usage: brbw centerFreq bandwidth source dest\n");
	exit(1);
    }

    if (source.setInput(argv[3]) < 0) {
	fprintf(stderr, "brbw: cannot open input: %s\n", argv[3]);
	exit(1);
    }
    brbw.setInput(&source);
    if (dest.setInputOutput(&brbw, argv[4]) < 0) {
	fprintf(stderr, "brbw: cannot open output: %s\n", argv[4]);
	exit(1);
    }

    sscanf(argv[1], "%lf", &freq);
    sscanf(argv[2], "%lf", &bw);
    brbw.setCenterFreqAndBW(freq, bw);

    dest.run();

    exit(0);
}
