#!/usr/local/bin/wish -f
# send a voice command to synth (sau 4/93)

#                      Copyright (c) 1992,1993 Bellcore
#                            All Rights Reserved
#       Permission is granted to copy or use this program, EXCEPT that it
#       may not be sold for profit, the copyright notice must be reproduced
#       on copies, and credit should be given to Bellcore where it is due.
#       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.

wm title . "Sparc-O-matic voicing"
wm iconname . "voice"
wm geometry . +30+30
wm minsize  . 100 200

set partials "1 2 3 4 5"
set voice 1
set do_send 0

# find a "synth" interpreter"

set interps [winfo interps]
set indx [lsearch $interps "synth*"]
# puts stderr "$interps <$indx>"

# handle window resizes 

proc get_font {s} {
	return "-*-helvetica-medium-*-*-*-*-$s-*-*-*-*-*-*"
 	}
proc resize {w h} {
	global widgets font_size message
	set size 120
	if {$w < 250 || $h < 250} {set size 100}
	if {$w < 200 || $h < 200} {set size 80}
	if {$w > 350 && $h > 350} {set size 180}
	if {$w > 500 && $h > 450} {set size 240}
	if {$size != $font_size} {
		set font_size $size
		after 1000 {set message ""}
		set font [get_font $size]
		foreach i "$widgets" {
			catch {$i configure -font $font}
			}
		set message "Changing font size"
		}
	}

# make a partial slider set

proc make_partial {w n} {
	frame $w.$n -border 4 -relief raised -background #132
	label $w.$n.l -text "partial $n"

	set max(w) 100; set max(d) 40
	foreach i "w d" {
		frame $w.$n.$i
		label $w.$n.$i.l -textvariable $i$n -width 3 -text "0"
		label $w.$n.$i.x -text $i -width 3
		scale "$w.$n.$i.s" -orient vertical -from $max($i) -to 0 \
			-command "slide  $n $i"  -showvalue false
		pack append $w.$n.$i \
			$w.$n.$i.x {bottom} \
			$w.$n.$i.l {bottom} \
			$w.$n.$i.s {top filly expand}
		bind  $w.$n.$i.l <Button-3> \
			"incr $i$n; $w.$n.$i.s set \$$i$n; set $i$n \[$w.$n.$i.s get\]"
		bind  $w.$n.$i.l <Button-1> \
			"incr $i$n -1; $w.$n.$i.s set \$$i$n; set $i$n \[$w.$n.$i.s get\]"
		}

	pack append $w.$n $w.$n.l {top fillx} \
		$w.$n.w {left filly} \
		$w.$n.d {right filly}
	return $w.$n
	}

# the slider commands 

proc slideX {param value} {
	global voice global do_send
	# puts stderr "v=$voice;$param=$value;"
	if {$do_send} {do_cmd "v=$voice;$param=$value;"}
	}

proc slide {n p v} {
	global $p$n voice
	set $p$n "$v"
	do_cmd "v=$voice;p=$n;$p=$v;"
	}

# send a command to the interpreter

proc do_cmd {cmd} {
	global interp voice

	set do "remote {$cmd} {setting voice $voice parameters}"
	# puts stderr "sending $cmd <$do> to $interp"
	set code [catch {send $interp $do} result]
	if {$code != "0"}  {set message "The synthesizer died"}

	# puts stderr "done <$result>"
	return "$result"
	}

# Accumulate the current voice parameters in a string

proc save_voice  {voice} { 
	global partials

	set result "v=$voice;"
	append result "s=[.main.stretch get];"
	append result "c=[.main.cutoff get];"
	foreach i "$partials" {
		append result "p=$i;"
		append result "w=[.bottom.$i.w.s get];"
		append result "d=[.bottom.$i.d.s get];"
		}
	return "$result"
	}
	
# read the voice parameters from  the synthesizer

proc fetch_voice {voice} { 
	global partials global do_send

	set do_send 0
	set result [do_cmd "v=$voice;?"]
	# puts stderr "got $result"
	scan "$result" "voice=%d; cutoff=%d; stretch=%d" foo c s
	# puts stderr "result=$result"
	# puts stderr "c=$c s=$s"
	.main.stretch set "$s"
	.main.cutoff  set "$c"
	foreach i "$partials" {
		set result [do_cmd "v=$voice;p=$i;?"]
		scan "$result" "voice=%d; partial=%d; weight=%d; damping=%d" f1 f2 w d
		.bottom.$i.w.s set "$w"
		.bottom.$i.d.s set "$d"
		}
	set do_send 1
	}
	
# save current voice

proc save {} {
	global voice message

	set message "appending voice $voice to VOICE"
	set file [open VOICE a]
	puts $file [save_voice $voice]
	close $file
	set message "done saving"
	after 1000 {set message ""}
	}

proc revert {} {}

# build the widgets 

frame .top -background #48A
frame .main -background #A62 -border 3 -relief raised
frame .bottom
label .message -textvariable message -background #629 -foreground red
pack append . .top {top fillx} \
	.main {top fillx} \
	.message {bottom fillx} \
	.bottom {bottom expand fill}

# now find the synthesizer 

if {$indx == "-1" } {
	set message "No Sparc-O-matic is running to send commands to"
	after 5000
	destroy .
	return
	}
set interp [lindex $interps $indx]

# the partial controllers

foreach i "$partials" {
	pack append .bottom [make_partial .bottom $i] {left expand}
	}

# the stretch and cutoff

label .main.str_lab -text "stretch" -border 3 -relief raised
scale .main.stretch -orient horizontal -from -10 -to 80 \
		-command "slideX  s" -border 3 -relief raised
label .main.cut_lab -text "cutoff" -border 3 -relief raised
scale .main.cutoff -orient horizontal -from 100 -to 4000 \
		-command "slideX  c"  -border 3 -relief raised
bind  .main.str_lab <Button-1> \
	{.main.stretch set [expr {[.main.stretch get] - 1}]}
bind  .main.str_lab <Button-3> \
	{.main.stretch set [expr {[.main.stretch get] + 1}]}
bind  .main.cut_lab <Button-1> \
	{.main.cutoff set [expr {[.main.cutoff get] - 5}]}
bind  .main.cut_lab <Button-3> \
	{.main.cutoff set [expr {[.main.cutoff get] + 5}]}

pack append .main \
	.main.str_lab {left filly} \
	.main.stretch {left fill expand} \
	.main.cut_lab {left filly} \
	.main.cutoff {left fill}

# make voice buttons

frame .top.voices
label .top.voices.lab -text voice
pack append .top.voices .top.voices.lab {left filly}
foreach i "1 2 3 4 5 6 7 8" {
	radiobutton .top.voices$i  -text $i -width 1 -value $i -variable voice \
		-selector "red"  -command "fetch_voice $i"
	pack append .top.voices .top.voices$i {left filly}
	}
		

# entry .top.entry -textvariable command -width 5
button .top.quit -text quit -command "destroy ."
button .top.save -text save -command "save"
button .top.revert -text revert -command "revert"

pack append .top \
	.top.quit {right filly expand} \
	.top.save {right filly expand} \
	.top.revert {right filly expand}   \
	.top.voices {right filly expand} 

bind . <Control-c> "destroy ."
# bind . <Configure> {resize %w %h}

# try to re-do fonts as needed
set widgets "[info commands .*]"
set font_size 140
fetch_voice 1
