#!/usr/local/bin/wish -f

# sample mpu controller (sau 4/93)

#                      Copyright (c) 1992,1993 Bellcore
#                            All Rights Reserved
#       Permission is granted to copy or use this program, EXCEPT that it
#       may not be sold for profit, the copyright notice must be reproduced
#       on copies, and credit should be given to Bellcore where it is due.
#       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.

set filename ""		;# file visible in entry area
set error_msg ""		;# error message displayed 
set state stopped		;# stopped or running
set note 0				;# which note is playing
set next ""				;# next command to send
# set synth	Synth		;# name of the synth binary
set synth	./synth		;# name of the synth binary
set curr_dir .			;# the current directory
set mask 003F			;# channel mask
set save_mask 003F	;# previous channel mask
set active "0000"		;# active channel mask
set tuning 0			;# tuning system (equal tempered)
set pd [pwd]			;# where are we?

# restart the synthesizer (just in case)

proc restart {} {
	global control synth state pd curr_dir

	puts stderr "stopping synth"
	puts $control "Q"
	flush $control
	gets $control line
	puts stderr "Stopped ($line)"
	close $control
	message "Restarting Synthesizer"
	puts stderr "returning to $pd"
	cd $pd
	set curr_dir .
	set control [open |$synth "w+"]
	send_synth "h=3000"	;#	set synthesizer hunk size
	set state stopped
	}

# sent a command to the synthesizer periodically

proc cycle {} {
	global next state
	
	send_synth $next
	set next ""
	after 200 cycle
	}

# manage a transaction with the synthesizer (s is the message)

proc send_synth {s} {
	global control note state active

	puts $control "$s"
	flush $control
	set result [gets $control]
	set ok [lindex $result 0]
	if {$ok != "*"} {
		set error_msg "$result"
		after 3000
		destroy .
		}
		
	set note [lindex $result 1]
	set got [lindex $result 3]
	if {$got != "0000"} {set active $got}
	if {[lindex $result 2] == "-"} {
		set state stopped
		set active "0000"
		catch {.top.run configure -text stopped}
	} {
		set state running
		catch {.top.run configure -text running}
	}
	return [lindex $result 4]
}

#  run a command from a remote interpreter

proc remote {cmd msg} {
	message "remote command: $msg"
	send_synth "$cmd"
	}

#	get a synth command from a slider motion

proc slide_cmd {command value} {
	global next x$command
	set next "$next$command=$value;"
	set x$command $value
	}

# make a slider

proc do_slide {name min max init label code} {
	frame $name -borderwidth 3 -background #317 -relief raised
	label $name.top -text "$label" -foreground #201
	label $name.bottom -textvariable x$code -width 3 -foreground #201
	scale $name.scale -orient vertical -from $max -to $min \
		-command "slide_cmd  $code" -showvalue false -width 10
	pack append $name $name.top {top fillx} \
			$name.scale {top expand fillx} \
		 	$name.bottom {bottom fillx}
	$name.scale set $init
	slide_cmd  $code $init	;# initialize values
	}

# print an error message for a few seconds

proc message {msg} {
	global error_msg
	set error_msg $msg
	# puts stderr "Message: $msg"
	after 3000 set error_msg "--"
	}

#manage the file name

proc check_file {win} {
	global control filename next curr_dir

	if {[file isdirectory $filename]} {
		message "Changing to directory $filename"
		set curr_dir $curr_dir/$filename
		cd $filename
		set filename ""
		return 0
		}
	if {![file exists "$filename"]} {
		message "File $filename does not exist"
		return 0
		}
	if {[string range $filename 0 0] == "/"} {
		slide_cmd "F" $filename
	} else {
		slide_cmd "F" $curr_dir/$filename
		}
	message "selecting file $filename"
	set next "$next+;"
	return 1
	}

# manage the run/stop state

proc run_button {} {
	global state filename next

	if {$state == "stopped"} {
		set state running
		.top.run configure -text stopped
		set next "$next+;"
	} else {
		set state stopped
		.top.run configure -text running
		set next "$next-;"
	}
}

# get a list box selection

proc list_select {parent} {
	global filename
	set index [$parent.list curselection]
	set filename [$parent.list get $index]
	puts stderr  "listbox got $filename"
	destroy $parent
	}

# start the list box for file name selection

proc do_options {w} {
	global filename curr_dir
	# puts stderr "in do options button $filename"

	catch {destroy $w}
	toplevel $w
	wm geometry $w +100+130
	wm title $w "Sparc-O-matic file selector"
	wm minsize $w 1 1

	scrollbar $w.scroll -command "$w.list yview" -border 2
	listbox $w.list -yscroll "$w.scroll set" -setgrid 1
	tk_listboxSingleSelect $w.list
	pack append $w $w.scroll {right filly} $w.list {left expand fill}
	$w.list insert 0 ".."
	foreach i [lsort [glob -nocomplain *.mpu]] {$w.list insert end $i}
	bind $w.list <Control-c> "destroy $w"
	bind $w.list <Double-Button-1> "list_select $w"
	}

# get a channel mask entry, send to synthesizer

proc send_mask {win} {
	global mask save_mask
	set get ""

	if {[scan "$mask" "%x" get] == 1 && $get <= 0xFFFF} {
		set mask [format "%.04x" "$get"]
		send_synth  "m=$mask"
		set save_mask $mask
		}
	set mask $save_mask
	eval "$win configure -foreground red"
	after 2000 "$win configure -foreground black"
	}

# ping for send

proc ping {} {}

# geometry stuff

wm title . "Sparc-O-matic MIDI Synthesizer"
wm iconname . "Sparc-O-matic"
wm geometry . +100+100
frame .top -relief raised -borderwidth 2
frame .bottom -borderwidth 2
label .message -textvariable error_msg -foreground red -background #37F
pack append . .top {top fillx} \
	.message {bottom fillx} \
	.bottom {bottom expand fill}

# top line 

label  .top.label -text file:
entry  .top.file -textvariable filename -width 14 -relief flat -border 3
focus  .top.file
focus  default .top.file
button .top.options -text "files..." -command {do_options .top.options.w}
label  .top.note -textvariable note  -width 5 -relief raised -border 3
button .top.run -text start -command run_button -width 8
button .top.quit -text "quit" -command {
	puts $control "Q"
	flush $control
	close $control
	destroy .
	}
bind .top.quit <Button-2> restart

pack append .top \
	.top.label left \
	.top.file {left expand} \
	.top.quit right \
	.top.run right \
	.top.note right \
	.top.options right

# sliders

do_slide .bottom.s1  1 10 8 volume g
do_slide .bottom.s2 20 200 100 legato l
do_slide .bottom.s3 -24 24 0 transp t
do_slide .bottom.s4 40 220 120 speed T
do_slide .bottom.s5 1 10 4 intens f
pack append .bottom .bottom.s1 {left expand} .bottom.s2 {left expand} \
		.bottom.s3 {left expand} .bottom.s4 {left expand} .bottom.s5 {left expand}
bind   .top.file <KeyPress-Return> "check_file .top.file"
# bind   .top.file <Button-3> {do_options .top.file}

# add right edge

frame .bottom.r -border 3 -relief raised
label .bottom.r.l -text "tuning"
pack append .bottom.r .bottom.r.l top
foreach i "0 1 2" {
	radiobutton .bottom.r.$i -text $i -width 1 -value $i -variable tuning \
		-selector "red" -command "send_synth z=$i"
	pack append .bottom.r .bottom.r.$i {top fillx}
	}
label .bottom.r.l1 -text active -foreground red -border 2 -relief raised
label .bottom.r.l2 -textvariable active -border 2 -relief raised
label .bottom.r.l3 -text mask -border 2 -relief raised
entry .bottom.r.e -width 4 -textvariable mask -border 2 -relief raised 
bind .bottom.r.e <Button-3> "send_mask .bottom.r.e"
bind .bottom.r.e <KeyPress-Return> "send_mask .bottom.r.e"
pack append .bottom.r .bottom.r.l1 {top} .bottom.r.l2 {top}
pack append .bottom.r .bottom.r.l3 {top} .bottom.r.e {top}
pack append .bottom .bottom.r {left}
 
# set initial direcory (broken?)

puts stderr "args: $argv <[lindex $argv 0]>"
if {$argc > 1 && [file isdirectory [lindex $argv 0]]}  {
	set curr_dir [lindex $argv 0]
	cd $curr_dir
	message "starting in directory $curr_dir"
	}

set control [open |$synth "w+"]
puts stderr "started $synth"
send_synth "h=3000"	;#	set synthesizer hunk size
after 200 cycle		;# start the synthesizer interaction
