#!/usr/local/bin/wish -f
# send an arbitrary command to synthysizer (sau 4/93)

#                      Copyright (c) 1992,1993 Bellcore
#                            All Rights Reserved
#       Permission is granted to copy or use this program, EXCEPT that it
#       may not be sold for profit, the copyright notice must be reproduced
#       on copies, and credit should be given to Bellcore where it is due.
#       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.

set command ""
set result "type a synth command"

# find a "synth" interpreter"

set interps [winfo interps]
set indx [lsearch $interps "synth*"]
puts stderr "$interps <$indx>"

wm title . "test send"
wm iconname . "MIDI"
wm geometry . +30+30
label .label -textvariable result 
entry  .entry -textvariable command -width 40 -relief flat -border 3
pack append . .entry {top fillx} .label {bottom fillx}
bind .entry <Control-c> "destroy ."

if {$indx == "-1" } {
		set result "No Sparc-O-matic is running to send commands to"
		after 5000
		destroy .
		return
		}

set interp [lindex $interps $indx]
focus .entry
bind .entry <KeyPress-Return> {do_cmd}

proc do_cmd {} {
	global command result interp

	set do "remote {$command} testing"
	puts stderr "sending $command <$do> to $interp"
	set code [catch {send $interp $do} result]
	puts stderr "Code is $code"
	if {$code != "0"}  "destroy ."

	puts stderr "done"
	set command ""
	}

proc ping {} {
	global interp

	if [catch "send $interp ping"] "destroy ."
	after 1000 ping
	}

ping
