#!/usr/local/bin/wish -f
# send a reverb command to synth (sau 5/93)

#                      Copyright (c) 1992,1993 Bellcore
#                            All Rights Reserved
#       Permission is granted to copy or use this program, EXCEPT that it
#       may not be sold for profit, the copyright notice must be reproduced
#       on copies, and credit should be given to Bellcore where it is due.
#       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.

wm title . "Sparc-O-matic reverb"
wm iconname . "reverb"
wm geometry . +50+50
wm minsize  . 100 200

set reverbs "1 2 3"
set do_send 0

# find a "synth" interpreter"

set interps [winfo interps]
set indx [lsearch $interps "*synth*"]

# make a reverb slider set

proc make_reverb {w n} {
	frame $w.$n -border 4 -relief raised -background #132
	label $w.$n.l -text "reverb $n"

	set max(d) 25; set max(g) 17
	foreach i "d g" {
		frame $w.$n.$i
		label $w.$n.$i.l -textvariable v$i$n -width 3 -text "0"
		label $w.$n.$i.x -text $i -width 3
		scale "$w.$n.$i.s" -orient vertical -from $max($i) -to 0 \
			-command "slide $i$n"  -showvalue false
		pack append $w.$n.$i \
			$w.$n.$i.x {bottom} \
			$w.$n.$i.l {bottom} \
			$w.$n.$i.s {top filly expand}
		bind  $w.$n.$i.l <Button-3> "do_incr $w $i $n 1"
		bind  $w.$n.$i.l <Button-1> "do_incr $w $i $n -1"
		}

	pack append $w.$n $w.$n.l {top fillx} \
		$w.$n.d {left filly} \
		$w.$n.g {right filly}
	return $w.$n
	}

# incr/decr slider values (called via bind)

proc do_incr {win var indx incr} {
	set x [$win.$indx.$var.s get]
	incr x $incr
	eval "$win.$indx.$var.s set $x"
	set x [$win.$indx.$var.s get]
	set v$var$indx [convert $x]
	}

# the slider value conversion some sort of log scale

proc convert {x} {
	expr "(($x&1 ? 3:2) << ($x/2))-2"
	}

# the slider command  (temporary)

proc slide {var value} {
	global vd1 vg1 vd2 vg2 vd3 vg3
	set v$var [convert $value]
	do_cmd "r=$vd1 $vg1 $vd2 $vg2;"
	}

# send a command to the interpreter

proc do_cmd {cmd} {
	global interp voice

	set do "remote {$cmd} {setting reverb parameters}"
	set code [catch {send $interp $do} result]
	if {$code != "0"}  {set message "The synthesizer died"}

	# puts stderr "done <$result>"
	return "$result"
	}

# build the widgets 

frame .top -background #48A
frame .middle
label .message -textvariable message -background #629 -foreground red
pack append . .top {top fillx} \
	.message {bottom fillx} \
	.middle {bottom expand fill}

# now find the synthesizer 

if {$indx == "-1" } {
	set message "No Sparc-O-matic is running to send commands to"
	after 5000
	destroy .
	return
	}
set interp [lindex $interps $indx]

# the reverb controllers

foreach i "$reverbs" {
	pack append .middle [make_reverb .middle $i] {left expand}
	}

button .top.quit -text quit -command "do_cmd r=; destroy ."

pack append .top \
	.top.quit {right filly expand} \

bind . <Control-c> "destroy ."
puts stderr "starting"
