/*                      Copyright (c) 1992,1993 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 */

/* run an audio signal through a reverb filter */

#include <sys/time.h>
#include <math.h>
#include <stdio.h>
#include "audio.h"
#include "reverb.h"

#define ssleep() \
   { \
   struct timeval time; \
   time.tv_sec = 0; \
   time.tv_usec = 50000; \
   select(0,0,0,0,&time); \
   }

#define HUNK	300				/* hunk size */

float buff[HUNK];					/* unput buffer */
char line[100];

struct reverb_params data[3] = {
	0,0, 0,0, 0,0
	};

main(argc,argv)
int argc;
char **argv;
	{
	char *getenv();
	int n;					/* # of elements in current hunk */
	int start = 0;			/* true iff running */
	int out_fd=0;			/* output fd */
	int in_fd=0;			/* input fd */
	char *result="start";		/* command result (if error) */
	char *cookie;
	int ok=0;
	float gain=.5;		/* overall gain */
	int xtra = 4000;	/* end of file reverb time */
	int wrote;						/* number of bytes written */

	printf("READY\n"); fflush(stdout);

	/* fix this */

	cookie = reverb_init(data);
	while (1) {
		if (wait_read(0,line,sizeof(line)) > 0) {
			line[strlen(line)-1] = '\0';
			result = "invalid command";
			switch(*line) {
				case '+':			/* start output */
					if (start==0 && in_fd >0 && ok)  {
						start++;
						out_fd = open("/dev/audio",1);
						result="starting";
						wrote=0;
						}
					break;
				case '-':			/* stop output */
					if (start) {
						start=0;
						result="stopping";
						close(out_fd);
						}
					break;
				case 'F':			/* new input file */
					if (in_fd>0) close(in_fd);
					if(line[2]) in_fd = open(line+1,0);
					result = in_fd>0 ? "opened file" : "bad file";
					break;
				case 'Q':			/* quit */
					exit(0);
					break;
				case 'R':			/* reverb coef's */
					n = sscanf(line+1,"%d %d %d %d",
							&data[0].delay, &data[0].gain,
							&data[1].delay, &data[1].gain);
					if (n != 4) break;
					data[1].delay = data[1].gain = 0;
					sprintf(line,"(D%d,G%d) (D%d,G%d)",
						data[0].delay,data[0].gain,data[1].delay,data[1].gain);
					result = line;
					ok++;
					break;
				}
			printf("%s\n",result); fflush(stdout);
			bzero(line,sizeof(line));
			}
			
		if (start == 0) {
			ssleep();continue;
			}
			
		if (wrote - audio_wrote(out_fd) > 1200) {
			ssleep();
			continue;
			}

		n = input(in_fd,buff,HUNK);
		if (n <=0) {
			start = 0;
			close(out_fd);
			result = "EOF";
			}
		else
			{
			reverb(cookie,buff,buff,n);
			output(out_fd,buff,n);							/* output data */
			wrote += n;
			}
		}
	}

char ulaw[HUNK];

output(fd,x,n)
int fd;
float *x;											/* data to output */
int n;												/* number of items */
	{
	char *s = ulaw;
	int sample;
	int count = n;
	while (n-- > 0) {
		sample = *x++;
		*s++ = Ub2i[(B13ZERO + sample) & B13MAX]; 
		}
	write(fd,ulaw,count);
	}

/* return # of samples written */

int
audio_wrote(fd)
int fd;
   {
   int n;
   struct audio_info info;

   n = ioctl(fd,AUDIO_GETINFO,&info);
	if (n<0)
		return(-1);
	else
		return(info.play.samples);
   }

/* read from fd non blocking */

int
wait_read(fd,buff,n)
int fd;			/* file descriptor to read from */
char *buff;		/* read into here */
int n;			/* max # to read */
	{
	int mask = 1<<fd;
	int cnt=0;
   struct timeval time;
   time.tv_sec = 0;
   time.tv_usec = 0;

	if (select(32,&mask,0,0,&time)==1) {
		cnt = read(fd, buff, n);
		}
	return(cnt);
	}

int
input(fd,in,n)
int fd;		/* fd to read from */
float *in;		/* where to put the result */
int n;		/* number to read */
	{
	float *end = in + n;
	unsigned char *m = ulaw;

	if (fd <=0) return(0);
	n = read(fd,ulaw,n);
	
	while(in < end)
		*in++ = I2sb[*m++];
	return(n);
	}
