#!/bin/wish -f
# sample band pass filter stuff

#                      Copyright (c) 1992,1993 Bellcore
#                            All Rights Reserved
#       Permission is granted to copy or use this program, EXCEPT that it
#       may not be sold for profit, the copyright notice must be reproduced
#       on copies, and credit should be given to Bellcore where it is due.
#       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.

set cmd ./filt
set control [open |$cmd "r+"]
puts stderr "starting $cmd, waiting for response..."
gets $control foo
puts stderr "Starting"

# do a slider command

set fc "1000"
set f3 "100"
set gain "1"
proc slide {var value} {
	global fc f3 gain

	set $var $value
	do "B $fc $f3 $gain"
	}

# send a command to the filter, display the result

set item ""
proc do {s} {
	global control message item

	puts $control "$s"
	flush $control
	gets $control line
	if { [string range $line 0 0] == "P"} {
		set line [string range $line 2 end]
		if {$item != ""} { .can delete $item}
		#eval "set item \[.can create line $line\]"
		eval "set item \[.can create polygon $line -fill red \]"
	} else {
		set message $line
		}
	}

# select /dev/audio as input file

proc audio {} {
	global message filename

	set message "reading input from /dev/audio"
	set filename ""
   do "F/dev/audio"
	}

# manage the file name

set curr_dir [pwd] 
proc check_file {name} {
   global message curr_dir filename

   if {[file isdirectory $name]} {
      set message "Changing to directory $curr_dir/$name"
      set curr_dir $curr_dir/$name
      cd $name
		set filename ""
      return 0
      }
   if {![file exists "$name"]} {
      set message "File $name does not exist"
      return 0
      }
   do "F$curr_dir/$name"
   return 1
   }

wm title . "Band Pass Filter Demo"
frame .top
label .top.lab -text file:
button .top.start -text "start" -relief raised -command \
	{do +;set message running}
button .top.stop -text  "stop" -relief raised -command \
	{do -;set message stopped}
button .top.quit -text  "quit" -relief raised -command {do Q; destroy .}
entry .top.file -textvariable filename -width 25 -border 3 -relief raised
bind  .top.file <KeyPress-Return> {check_file $filename}    
bind  .top.file <Button-2> audio

pack append .top \
		.top.lab {left} \
		.top.file {left fillx expand} \
		.top.start {left} \
		.top.stop {left} \
		.top.quit {left}

canvas .can -height 100
scale .fc -orient horiz -to 4000 -from 100 \
	-command "slide fc" -label "Center Frequency"
scale .f3 -orient horiz -to 750 -from 1 \
	-command "slide f3" -label "3db width"
scale .gain -orient horiz -to 10 -from 1 \
	-command "slide gain" -label "filter gain"

label .bottom -textvariable message

pack append . .top {top fillx} \
				.can {top fillx expand} \
				.fc {top fillx expand} \
				.f3 {top fillx expand} \
				.gain {top fillx expand} \
				.bottom {bottom fillx expand}
bind . <Control-c> {puts $control Q; destroy .}
update
do "S [winfo width .can] [winfo height .can]"

set message "Stopped"
