#                      Copyright (c) 1992,1993 Bellcore
#                            All Rights Reserved
#       Permission is granted to copy or use this program, EXCEPT that it
#       may not be sold for profit, the copyright notice must be reproduced
#       on copies, and credit should be given to Bellcore where it is due.
#       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.


# TK inerface to audiocntl (SAU 6/93 - broken )


wm title . "audio controller"
wm iconname . "audio"
wm geometry . +1+350

proc make_slide {w n} {
	frame $w.$n
	label $w.$n.value -textvariable $n  -text "0"
	label $w.$n.name -text $n
	scale $w.$n.slide -orient vertical -from 255 -to 0 \
			-command "slide  $n"  -showvalue false
	pack append $w.$n \
			$w.$n.value {bottom fillx} \
			$w.$n.slide {bottom filly expand} \
			$w.$n.name {top fillx}
	return $w.$n
	}

proc get_settings {} {
	global play record mon port

	set x [audiocntl status]
	set n_play [lindex [split [lindex $x 2] /] 0]
	set n_record [lindex [split [lindex $x 5] /] 0]
	set n_mon [lindex [split [lindex $x 8] /] 0]
	set n_port [lindex $x 11]

	if {$n_play != $play} {set play $n_play}
	if {$n_record != $record} {set record $n_record}
	if {$n_mon != $mon} {set mon $n_mon}
	after 1000 get_settings
	}

frame .main
make_slide .main play
make_slide .main record
make_slide .main mon
frame .output
radiobutton .output.internal -text internal -value internal -variable port \
	-selector red -command "do_button internal"
radiobutton .output.external -text external -value external -variable port \
	-selector red -command "do_button external"
pack append .output .output.internal left .output.external right


pack append .main .main.play left .main.record left .main.mon left
pack append . .output top .main {top expand}

proc slide {n v} {
	global $n
	set $n $v
	audiocntl $n $v
	}

proc do_button x {
	audiocntl $x
	}

bind . <Control-c> "destroy ."

get_settings
