// valueslider.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// a ValueSlider is a MonoScene subclass which displays a TextInput item and 
// a horizontal slider with labels indicating the min and max values for it.
// The slider is tied to the TextInput in such a way that the value displayed
// in the TextInput is updated by the position of the slider, and vice-versa.

#ifndef VALUESLIDER_H
#ifdef __GNUG__
#pragma interface
#endif
#define VALUESLIDER_H

#include <InterViews/scene.h>

class ButtonState;
class Interactor;
class QueryValue;
class Range;
class RangedQueryValue;
class TextInput;

class ValueSlider : public MonoScene {
public:
	enum Mode { Integer, Double };
public:
	ValueSlider(ButtonState *, RangedQueryValue*, Mode);
	virtual ~ValueSlider();
	TextInput* getTextInput() { return (TextInput *) textInput; }
protected:
	redefined void Resize();
	virtual Interactor* createTextInput(ButtonState*, QueryValue*, const Range&);
	virtual Interactor* createNumberLabel(double);
private:
	Mode numberMode;
	Interactor* textInput;
	Interactor* slider;
};

#endif
