// framegraph.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// The subclass of Graph specialized for displaying data in "cascade" style
// with a simulated x-y-z axis display.  Currently, the FrameGraph is a non-
// editing display (i.e., output-only).

#ifndef FRAMEGRAPH_H
#ifdef __GNUG__
#pragma interface
#endif
#define FRAMEGRAPH_H

#include "graph.h"

class Controller;
class Selector;
class GraphPlot;
class Brush;

class FrameGraph : public Graph {
	typedef Graph Super;
public:
	enum VerticalScaleUnits { Amplitude, Decibels };
	FrameGraph(Controller *c, Data *data, const Range& verticalRange);
	FrameGraph(Controller *c, Data *data);
	virtual ~FrameGraph();
	// redefined InterViews methods
	redefined void Reconfig();
	redefined void Update();
	
	redefined int vertOriginLocation();
	redefined double currentVGrain();
	redefined const char* verticalScaleLabel();
	redefined int currentWidth();
	redefined int currentHeight();

	redefined void setInsertPoint(int) {}
	redefined void setEditRegion(const Range &) {}
	redefined void unSelect() {}
	// methods new to class
	double verticalGrain() { return vertGrain; }
	void setVerticalGrain(double newgrain);
	void setVerticalScaleUnits(VerticalScaleUnits);
	void setAxisOffsets(int horiz, int vert);
	virtual int horizShift() { return hshift; }
	virtual int vertShift() { return vshift; }
	boolean scaleInAmplitude() { return vScaleUnits == Amplitude; }
protected:
	// redefined InterViews methods
	redefined void Redraw(Coord, Coord, Coord, Coord);
	redefined void RedrawList(int n, Coord[], Coord[], Coord[], Coord[]);

	// methods new to class
	virtual int framesVisible();
	virtual int channelsVisible();
	virtual int frameSize();
	virtual double currentFrameGrain();
	virtual void setHorizShift(int hsh);
	virtual void setVertShift(int vsh);

	redefined void setReferenceRange();
	redefined void select() {}
	redefined void selectAll() {}
	redefined void selectAllVisible() {}
	redefined void grab(Event &);
	redefined void track(Event &) {}
	redefined void processKeyEvent(Event &) {}

	redefined boolean isViewChanged(Perspective &np);
	redefined void setShape();
protected:
	friend Controller;
	friend class DataView;
	friend class FrameView;
	GraphPlot** graphplots;	// waveform plot array
	Selector *selector;			// edit selection object
	int* frameNumbers;		// cache for frame number display
private:
	void Init();
	redefined void doResize();
	redefined void createPlot();
	redefined void loadPlot();
	redefined void doPlot();
//	void setInsertCoord(Coord loc=0);
//	void setRegionCoords(const Range &);
	void constrainOffsets(int& x, int& y);
	const char* getLabel(char* label, int frame);

	int oldFramesVisible;
	int maxPlots;
	int hshift;					// total offset of plots from left to right
	int vshift;					// total offset of plots from back to front
	double vertGrain;
	VerticalScaleUnits vScaleUnits;	// Amplitude or Decibel
private:
	Brush* dashBrush;
};

#endif
