// dialogbox.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Subclasses of InterViews Dialog class.  The new display() method pops up
// the DialogBox centered in whichever Interactor canvas has been passed to
// the DialogConstructor that created it, without use of the Event passed to
// Popup(), which is how it would have been done in the original Dialog class.

#ifndef DIALOGBOX_H
#ifdef __GNUG__
#pragma interface
#endif
#define DIALOGBOX_H

#include <InterViews/dialog.h>
#include "localdefs.h"

class DialogConstructor;

class DialogBox : public Dialog {
	typedef Dialog Super;
public:
	static void overrideWindowManager(boolean b) { override_WindowManager = b; }
	static boolean overrideWindowManager() { return override_WindowManager; }
	static void setBeepLevel(int level) { beep_Level = level; }
	static int beepLevel() { return beep_Level; }
public:
	redefined Interactor* Wrap(Interactor *);
    redefined boolean Popup(Event&, boolean b=false);
    redefined boolean Accept();
	virtual int display();
protected:
	DialogBox(ButtonState* s, Interactor* u, Response r);
	virtual void reset();
	void setBell(boolean b) { useBell = b; }
	void bell();
	void appear();
	virtual int getAnswer() = 0;
	virtual boolean acceptible(int) = 0;
	virtual void eventLoop(Event &);
	void disappear();
protected:
	Response defaultResponse;				// only used in confirm and choice
private:
	static boolean override_WindowManager;	// determines panel display mode
	static int beep_Level;
private:
	friend DialogConstructor;
	boolean isChild(Interactor*);
	Interactor* underlying;
	boolean useBell;
};

// an Alert contains any number of Messages and an "ok" button

class Alert : public DialogBox {
	typedef DialogBox Super;
	friend DialogConstructor;
protected:
	static DialogBox* create(ButtonState* s, Interactor* u, Response r) {
		return new Alert(s, u, r);
	}
	Alert(ButtonState* s, Interactor* u, Response r);
	redefined void Reconfig();

	redefined int getAnswer();
	redefined boolean acceptible(int);
};

// a confirmer contains any number of messages and a confirm-cancel button pair

class Confirmer : public DialogBox {
	typedef DialogBox Super;
	friend DialogConstructor;
protected:
	static DialogBox* create(ButtonState* s, Interactor* u, Response r) {
		return new Confirmer(s, u, r);
	}
	Confirmer(ButtonState* s, Interactor* u, Response r);
	redefined void Reconfig();

	redefined int getAnswer();
	redefined boolean acceptible(int);
};

// ChoiceDialog contains any number of messages plus yes, no, & cancel buttons

class ChoiceDialog : public DialogBox {
	typedef DialogBox Super;
	friend DialogConstructor;
protected:
	static DialogBox* create(ButtonState* s, Interactor* u, Response r) {
		return new ChoiceDialog(s, u, r);
	}
	ChoiceDialog(ButtonState* s, Interactor* u, Response r);
	redefined void Reconfig();

	redefined int getAnswer();
	redefined boolean acceptible(int);
};

class TextInput;
class FileSelector;

// an InputDialog is a confirmer with text-entry items for user input

class InputDialog : public Confirmer {
	typedef Confirmer Super;
	friend DialogConstructor;
protected:
	static DialogBox* create(ButtonState* s, Interactor* u, Response r) {
		return new InputDialog(s, u, r);
	}
	InputDialog(ButtonState* s, Interactor* u, Response r);
	redefined void Reconfig();

	redefined void reset();
	redefined int getAnswer();
	redefined boolean acceptible(int);
	virtual int checkInput();		// new to this class
	void addTextInput(TextInput*);
	void addFileSelector(FileSelector* fs) { fileSelector = fs; }
protected:
	boolean editing;
	TextInput *textInput;			// linked list of TextEntry items
	FileSelector* fileSelector;		// file chooser (optional)
};

#endif
