/*

This software module was originally developed by 

Luke Dahl (E-mu Systems)


in the course of development of the MPEG-4 Audio (ISO/IEC 14496-3) standard. 
This software module is an implementation of a part of one or more 
MPEG-4 Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio 
(ISO/IEC 14496-3). ISO/IEC gives users of the MPEG-4 Audio (ISO/IEC 14496-3) 
free license to this software module or modifications thereof for use 
in hardware or software products claiming conformance to the MPEG-4 Audio 
(ISO/IEC 14496-3). Those intending to use this software module in hardware 
or software products are advised that its use may infringe existing patents. 
The original developer of this software module and his/her company, the 
subsequent editors and their companies, and ISO/IEC have no liability for 
use of this software module or modifications thereof in an implementation. 
Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3) conforming 
products. E-mu Systems retains full right to use the code for his/her own 
purpose, assign or donate the code to a third party and to inhibit third 
parties from using the code for non MPEG-4 Audio (ISO/IEC 14496-3) 
conforming products. This copyright notice must be included in all copies 
or derivative works. 

Copyright (C) 1997 E-mu Systems, Inc.

*/
/*****************************************************************************
;
;	sf_wave_def.h
;
;	Definitions and prototypes for saol SF wavetable synth
;
*****************************************************************************/


#ifndef SF_WAVE_DEF_H
#define SF_WAVE_DEF_H

#define DEBUG

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "sf_wave_equ.h"
#include "sfe_enab.h"
#include "y.tab.h"
#include "saol_sched.h"

/*	Function prototypes */
void sf_init_sp(struct SynthParams *p);
void sf_init_env(struct Env *env);
void sf_init_lfo(struct Lfo *l);
void sf_synth_top(context *cx, double *Left, double *Right, double *Rev, double *Chor,
	long rate, double sfbanknum, double chan, double midibank, double midipreset,
	double midinote, double keyvel);

void sf_osc(struct SynthParams *sp, int voice, double *buf);
void sf_lpf(struct SynthParams *sp, int voice, double *samp);
void env_gen(context *cx, int voice, int framesz);
void env_val(struct Env *e, EnvMessageType msg);
void lfo_val(struct Lfo *l);
void sf_bank_load(sa_decoder *sa, char *bankname, int banknum);
int decodeB2(int coef, int fc);
int decodeB1(int fc);


#endif /* SF_WAVE_DEF_H */
