/* ------------------------------------------------------------------------- */
/*                                                                           */
/* Bitmux.h  : Handling of bistream format for AAC Raw and AAC SCALEABLE     */
/*                                                                           */
/* ------------------------------------------------------------------------- */

#ifndef _bitmux_h_
#define _bitmux_h_

#include "common.h"
#include "bitstream.h"
#include "tf_main.h"
#include "nok_bwp_enc.h"
#include "nok_ltp_enc.h"
#include "aac_qc.h"

int write_ics_info (int nr_of_sfb, WINDOW_TYPE block_type, BsBitStream *fixed_stream, 
                    int window_shape, int num_window_groups, int window_group_length[]);

int sort_book_numbers(int book_vector[],
                      int output_book_vector[],
		      int nr_of_sfb,  int qdebug,
		      WINDOW_TYPE block_type,
		      BsBitStream *fixed_stream,
		      int write_flag);

/*
int  write_to_bitstream(int nr_of_sfb, WINDOW_TYPE block_type, int scale_factors[], BsBitStream *fixed_stream,
			BsBitBuffer *gcBitBufCh, int book_vector[], int data[], int len[], int qdebug, int huff[13][1090][4],
			int counter, int num_window_groups, int window_group_length[], int global_gain, int window_shape,
			QC_MOD_SELECT qc_select, int noise_nrg[], PRED_TYPE predictor_type,
                        NOK_LT_PRED_STATUS *nok_lt_status, NOK_BW_PRED_STATUS *nok_bwp_status);
                        */
int write_ind_cha_stream(int nr_of_sfb, WINDOW_TYPE block_type, int scale_factors[], BsBitStream *fixed_stream,
                         BsBitBuffer *gcBitBufCh, int book_vector[], int data[], int len[], int qdebug, int scale_flag,
                         int huff[13][1090][4], int counter, int num_window_groups, int window_group_length[],
                         int global_gain, int window_shape, int noise_nrg[],  PRED_TYPE predictor_type,
                         NOK_LT_PRED_STATUS *nok_lt_status, NOK_BW_PRED_STATUS *nok_bwp_status, int common_window);

int write_scalefactor_bitstream(int nr_of_sfb, int scale_factors[], int book_vector[],
                              BsBitStream *fixed_stream, int write_flag, int window_group_length[],
                              int num_window_groups, int global_gain, WINDOW_TYPE block_type,
                              int noise_nrg[], int qdebug, int huff[13][1090][4]);

int write_aac_cpe(int nr_of_sfb, WINDOW_TYPE block_type, BsBitStream *fixed_stream, int num_window_groups,
                  int window_group_length[], int window_shape, int common_window, int ms_mask, int ms_used[10][10]);


int write_aac_sce(BsBitStream *fixed_stream);

int write_aac_end_id(BsBitStream *fixed_stream);

#endif   /* define _bitmux_ */
