#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "lxt.h"

extern char *xvt_pastebuf;
extern int xvt_pastebufsz;

extern Void *lxt_selsrc;
extern int lxt_selsrctype;
extern Time lxt_selsrctm;
extern char *lxt_selsrcbuf;
extern Panel *lxt_selsrcpanel;
extern Void *lxt_seldest;
extern int lxt_seldesttype;

void
textsw_grabsel(t, tm)
/*
   Internal function.
   Attempt to grab the selection and stuff it from a textsw.
*/
Textsw *t;
Time tm;
{
	boolean check;
	char *selbuf;
	int bufsz, i, j, k;
	Time tmstamp;
	Atom tmatom;
	XEvent evt;
	void lxt_clearsel();

	/* see if there's any highlighted text to be stuffed */
	textsw_drawhlt(t, FALSE, &check);
	if (check == FALSE)
		return;

	/* get the highlighted text */
	selbuf= (char *) NULL;
	if (textsw_grabhlttext(t, &selbuf, &bufsz, TRUE, &i, &j, &k) != LX_SUCCESS)
		return;

	/* it's possible that although a highlight has been drawn,
	   no characters have actually been grabbed (e.g., the user
	   selected only a portion of a tab) */
	if (bufsz == 0) {
		textsw_drawhlt(t, TRUE, (boolean *) NULL);
		t->xt_drawhlt= FALSE;
		cfree(selbuf);
		selbuf= (char *) NULL;
		return;
	}

	/* restore newlines and remove spaceholders */
	for (i= 0; i < bufsz; i++) {
		if (selbuf[i] == '\0')
			selbuf[i]= '\n';
		else if (selbuf[i] == LXT_SPHOLDER) {
			for (j= i; j < bufsz; j++)
				selbuf[j]= selbuf[j+1];
			bufsz--;
		}
	}

	/* if we already own the selection in some other window, clear it */
	if (lxt_selsrc != (Void *) NULL)
		lxt_clearsel(TRUE);

	/* we need to generate a real timestamp to pass to
	   XSetSelectionOwner() to maintain ICCCM compliance
	   if tm was passed in as CurrentTime  --
	   this is done by performing a zero-length append
	   to a window property; if this fails, just use
	   CurrentTime and be happy that we tried */
	if (tm == CurrentTime) {
		if ((tmatom= XInternAtom(t->xt_dpy, "_LXT_ICCCM_TMSTAMP", False)) == None)
			tmstamp= CurrentTime;
		else {
			XChangeProperty(t->xt_dpy, t->xt_twin, tmatom, XA_STRING, 8, PropModeAppend, (unsigned char *) NULL, 0);
			XSync(t->xt_dpy, False);

			/* wait 5 seconds max to get notification, then give up */
			for (i= 5; i > 0; i--) {
				if (XCheckTypedWindowEvent(t->xt_dpy, t->xt_twin, PropertyNotify, &evt) == True)
					break;
				else
					sleep(1);
			}
			if (i > 0)
				tmstamp= ((XPropertyEvent *) &evt)->time;
			else
				tmstamp= CurrentTime;
		}
	}
	else
		tmstamp= tm;

	XSetSelectionOwner(t->xt_dpy, XA_PRIMARY, t->xt_twin, tmstamp);
	if (XGetSelectionOwner(t->xt_dpy, XA_PRIMARY) != t->xt_twin) {
		cfree(selbuf);
		selbuf= (char *) NULL;
		return;
	}

	lxt_selsrc= (Void *) t;
	lxt_selsrctype= LX_TEXTSW;
	lxt_selsrctm= tmstamp;
	lxt_selsrcbuf= selbuf;
	lxt_selsrcpanel= (Panel *) NULL;

	return;
}

void
textsw_sc_proc(t, evt)
/*
   Internal function.
   Handles notification from server of selection ownership loss.
*/
Textsw *t;
XSelectionClearEvent *evt;
{
	if (lxt_selsrc != (Void *) t)
		return;
	if (lxt_selsrctype != LX_TEXTSW)
		return;
	if (evt->time < lxt_selsrctm)
		return;
	if (t->xt_drawhlt == FALSE)
		return;

	if (t->xt_flags & LXP_FRAMEMAPPED)
		textsw_drawhlt(t, TRUE, (boolean *) NULL);
	t->xt_drawhlt= FALSE;

	lxt_selsrc= (Void *) NULL;
	lxt_selsrctype= LX_NULL;
	lxt_selsrctm= (Time) 0;
	if (lxt_selsrcbuf != (char *) NULL) {
		cfree(lxt_selsrcbuf);
		lxt_selsrcbuf= (char *) NULL;
	}
	lxt_selsrcpanel= (Panel *) NULL;

	return;
}

void
textsw_sr_proc(t, evt)
Textsw *t;
XSelectionRequestEvent *evt;
{
	void lxt_denysel(), lxt_sendsel();

	if (lxt_selsrc != (Void *) t) {
		lxt_denysel(t->xt_dpy, evt);
		return;
	}
	if (lxt_selsrcbuf == (char *) NULL) {
		lxt_denysel(t->xt_dpy, evt);
		return;
	}
	if (lxt_selsrctype != LX_TEXTSW) {
		lxt_denysel(t->xt_dpy, evt);
		return;
	}
	if ((evt->time < lxt_selsrctm) && (evt->time != CurrentTime)) {
		lxt_denysel(t->xt_dpy, evt);
		return;
	}

	lxt_sendsel(t->xt_dpy, evt);

	return;
}

void
textsw_sn_proc(t, evt)
Textsw *t;
XSelectionEvent *evt;
{
	char *selbuf;
	int len, i;
	char *lxt_getsel();
	void textsw_draw(), textsw_display();

	if (lxt_seldest != (Void *) t)
		return;
	if (lxt_seldesttype != LX_TEXTSW)
		return;

	if (evt->property == None) {
		XBell(t->xt_dpy, 10);
		return;
	}
	if (evt->target != XA_STRING) {
		XBell(t->xt_dpy, 10);
		return;
	}
	if ((selbuf= lxt_getsel(t->xt_dpy, t->xt_twin)) == (char *) NULL) {
		XBell(t->xt_dpy, 10);
		return;
	}
	if ((len= strlen(selbuf)) == 0) {
		XBell(t->xt_dpy, 10);
		return;
	}

	for (i= 0; i < len; i++) {
		if (selbuf[i] == '\n')
			selbuf[i]= '\0';
	}

	if (xvt_pastebuf != (char *) NULL)
		cfree(xvt_pastebuf);
	xvt_pastebuf= selbuf;
	xvt_pastebufsz= len;

	textsw_cleanuptext(t);
	textsw_draw(t);
	textsw_display(t);

	lxt_seldest= (Void *) NULL;
	lxt_seldesttype= LX_NULL;

	return;
}
